/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.storage;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.mimetype.MimeTypeResolver;
import net.mapeadores.util.text.FileName;
import net.mapeadores.util.text.RelativePath;

public final class IconScanEngine {
    public static final String ICON_PREFIX = "icon-";
    public static final String APPLETOUCHICON_PREFIX = "touchicon-";
    public static final String SHORTCUTICON_PREFIX = "shortcuticon-";
    public static final RelativePath ICON_FOLDER = RelativePath.build("images");

    private IconScanEngine() {
    }

    public static List<HtmlAttributes> run(ResourceStorages resourceStorages, MimeTypeResolver mimeTypeResolver) {
        SortedMap<String, RelativePath> resources = resourceStorages.listResources(ICON_FOLDER, false);
        ArrayList<HtmlAttributes> result = new ArrayList<HtmlAttributes>();
        for (String name : resources.keySet()) {
            try {
                FileName fileName = FileName.parse(name);
                HtmlAttributes htmlAttributes = IconScanEngine.toHtmlAttributes(fileName, mimeTypeResolver);
                if (htmlAttributes == null) continue;
                result.add(htmlAttributes);
            }
            catch (ParseException parseException) {}
        }
        return result;
    }

    private static HtmlAttributes toHtmlAttributes(FileName fileName, MimeTypeResolver mimeTypeResolver) {
        String rel;
        String sizes;
        String baseName = fileName.getBasename();
        if (baseName.startsWith(ICON_PREFIX)) {
            sizes = baseName.substring(ICON_PREFIX.length());
            rel = "icon";
        } else if (baseName.startsWith(APPLETOUCHICON_PREFIX)) {
            sizes = baseName.substring(APPLETOUCHICON_PREFIX.length());
            rel = "apple-touch-icon";
        } else if (baseName.startsWith(SHORTCUTICON_PREFIX)) {
            sizes = baseName.substring(SHORTCUTICON_PREFIX.length());
            rel = "shortcut icon";
        } else {
            return null;
        }
        sizes = sizes.replace('_', ' ');
        String mimeType = mimeTypeResolver.getMimeType(fileName.getExtension());
        return HA.href(ICON_FOLDER.buildChild(fileName.toString()).toString()).rel(rel).type(mimeType).attr("sizes", sizes);
    }
}

