/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.storage;

import fr.exemole.bdfserver.ResourceReference;
import fr.exemole.bdfserver.api.BdfExtensionInitializer;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.ResourceFolder;
import net.mapeadores.util.io.ResourceFolderBuilder;
import net.mapeadores.util.io.ResourceStorage;
import net.mapeadores.util.io.docstream.ClassResourceDocStream;
import net.mapeadores.util.mimetype.MimeTypeResolver;
import net.mapeadores.util.mimetype.MimeTypeUtils;
import net.mapeadores.util.text.RelativePath;

public class DistResourceStorage
implements ResourceStorage {
    private final ResourceFolder root;
    private final Map<String, Class> referenceClassMap;

    private DistResourceStorage(ResourceFolder root, Map<String, Class> referenceClassMap) {
        this.root = root;
        this.referenceClassMap = referenceClassMap;
    }

    public static ResourceStorage newInstance(List<BdfExtensionInitializer> bdfExtensionInitializerList) {
        HashMap<String, Class> referenceClassMap = new HashMap<String, Class>();
        RootBuilder rootBuilder = new RootBuilder();
        rootBuilder.addList(ResourceReference.class, "");
        for (BdfExtensionInitializer initializer : bdfExtensionInitializerList) {
            String startPath = StorageUtils.getExtensionResourcePath(initializer.getRegistrationName(), "");
            Class<?> referenceClass = initializer.getClass();
            rootBuilder.addList(referenceClass, startPath);
            referenceClassMap.put(initializer.getRegistrationName(), referenceClass);
        }
        return new DistResourceStorage(rootBuilder.toResourceFolder(), referenceClassMap);
    }

    @Override
    public String getName() {
        return "dist";
    }

    @Override
    public boolean containsResource(RelativePath path) {
        CheckedPath checkedPath = this.checkPath(path);
        if (checkedPath == null) {
            return false;
        }
        URL url = checkedPath.getReferenceClass().getResource("resources/" + checkedPath.getPathValue());
        return url != null;
    }

    @Override
    public DocStream getResourceDocStream(RelativePath path, MimeTypeResolver mimeTypeResolver) {
        CheckedPath checkedPath = this.checkPath(path);
        if (checkedPath == null) {
            return null;
        }
        ClassResourceDocStream classResourceDocStream = ClassResourceDocStream.newInstance(checkedPath.getReferenceClass(), "resources/" + checkedPath.getPathValue());
        if (classResourceDocStream == null) {
            return null;
        }
        String mimeType = MimeTypeUtils.getMimeType(mimeTypeResolver, checkedPath.getPathValue());
        classResourceDocStream.setMimeType(mimeType);
        return classResourceDocStream;
    }

    @Override
    public ResourceFolder getRoot() {
        return this.root;
    }

    private CheckedPath checkPath(RelativePath path) {
        String pathValue = DistResourceStorage.checkAlias(path.getPath());
        Class referenceClass = ResourceReference.class;
        if (pathValue.startsWith("ext-rsc/")) {
            referenceClass = null;
            int idx1 = pathValue.indexOf(47, "ext-rsc/".length());
            if (idx1 != -1) {
                String registrationName = pathValue.substring("ext-rsc/".length(), idx1);
                pathValue = pathValue.substring(idx1 + 1);
                referenceClass = this.referenceClassMap.get(registrationName);
            }
        }
        if (referenceClass == null) {
            return null;
        }
        return new CheckedPath(referenceClass, pathValue);
    }

    private static String checkAlias(String pathValue) {
        switch (pathValue) {
            case "css/_common_ficheblock.css": {
                return "css/_ficheblockelements.css";
            }
            case "css/_common_ficheblock_odt.css": {
                return "css/_ficheblockelements_odt.css";
            }
            case "css/_common_predefinedclasses.css": {
                return "css/_predefinedclasses.css";
            }
        }
        return pathValue;
    }

    private static class RootBuilder {
        private final ResourceFolderBuilder rootResourceFolderBuilder = new ResourceFolderBuilder("");

        private RootBuilder() {
        }

        private void addList(Class referenceClass, String startPath) {
            if (referenceClass.getResource("resources/list.txt") != null) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(referenceClass.getResourceAsStream("resources/list.txt"), "UTF-8"));){
                    String ligne;
                    while ((ligne = reader.readLine()) != null) {
                        if ((ligne = ligne.trim()).length() <= 0) continue;
                        try {
                            this.addPath(RelativePath.parse(startPath + ligne));
                        }
                        catch (ParseException parseException) {}
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void addPath(RelativePath relativePath) {
            String[] array = relativePath.toArray();
            int length = array.length;
            if (length > 1) {
                int lastIndex = length - 1;
                ResourceFolderBuilder subfolderBuilder = this.rootResourceFolderBuilder.getSubfolderBuilder(array[0]);
                for (int i = 1; i < lastIndex; ++i) {
                    subfolderBuilder = subfolderBuilder.getSubfolderBuilder(array[i]);
                }
                subfolderBuilder.addResource(array[lastIndex]);
            }
        }

        private ResourceFolder toResourceFolder() {
            return this.rootResourceFolderBuilder.toRessourceFolder();
        }
    }

    private static class CheckedPath {
        private final Class referenceClass;
        private final String pathValue;

        private CheckedPath(Class referenceClass, String pathValue) {
            this.referenceClass = referenceClass;
            this.pathValue = pathValue;
        }

        private Class getReferenceClass() {
            return this.referenceClass;
        }

        private String getPathValue() {
            return this.pathValue;
        }
    }
}

