/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.roles;

import fr.exemole.bdfserver.api.roles.FichePermission;
import fr.exemole.bdfserver.api.roles.Permission;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.api.roles.RoleDef;
import fr.exemole.bdfserver.api.roles.SphereSupervisor;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.exceptions.SwitchException;

public final class RoleUtils {
    public static final List<Role> EMPTY_ROLELIST = Collections.emptyList();
    public static final Permission NONE_PERMISSION = new DefaultPermission(0, null);
    public static final Permission STANDARD_PERMISSION = new DefaultPermission(1, null);
    public static final Permission ADMIN_PERMISSION = new DefaultPermission(3, null);
    public static final SphereSupervisor ALL_SPHERESUPERVISOR = new AllSphereSupervisor();

    private RoleUtils() {
    }

    public static boolean isDefaultRole(Role role) {
        return role.getName().equals("_default");
    }

    public static Permission toPermission(short permissionLevel, Permission.CustomPermission customPermission) {
        switch (permissionLevel) {
            case 0: {
                return NONE_PERMISSION;
            }
            case 1: {
                return STANDARD_PERMISSION;
            }
            case 2: {
                if (customPermission == null) {
                    throw new IllegalArgumentException("customPermission is null");
                }
                return new DefaultPermission(2, customPermission);
            }
            case 3: {
                return ADMIN_PERMISSION;
            }
        }
        throw new SwitchException("unknown permissionLevel: " + permissionLevel);
    }

    public static FichePermission toFichePermission(boolean create, short read, short write) {
        switch (read) {
            case 0: {
                throw new IllegalArgumentException("read cannot be none");
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new SwitchException("unknon read permissionType: " + create);
            }
        }
        switch (write) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new SwitchException("unknon create permissionType: " + write);
            }
        }
        if (write > read) {
            write = read;
        }
        if (write == 0) {
            create = false;
        }
        return new DefaultFichePermission(create, read, write);
    }

    public static boolean resolveFichePermissionType(short fichePermissionType, Redacteur redacteur, FicheMeta ficheMeta) {
        switch (fichePermissionType) {
            case 3: {
                return true;
            }
            case 0: {
                return false;
            }
            case 1: {
                return SphereUtils.ownsToRedacteur(ficheMeta, redacteur);
            }
            case 2: {
                return SphereUtils.ownsToSphere(ficheMeta, redacteur.getSphere());
            }
        }
        throw new SwitchException("corpusPermissionType = " + fichePermissionType);
    }

    public static boolean resolveReadPermission(Permission permission, Redacteur redacteur, FicheMeta ficheMeta) {
        switch (permission.getLevel()) {
            case 1: 
            case 3: {
                return true;
            }
            case 2: {
                return RoleUtils.resolveFichePermissionType(((FichePermission)permission.getCustomPermission()).read(), redacteur, ficheMeta);
            }
        }
        return false;
    }

    public static boolean resolveWritePermission(Permission permission, Redacteur redacteur, FicheMeta ficheMeta) {
        switch (permission.getLevel()) {
            case 1: 
            case 3: {
                return RoleUtils.resolveFichePermissionType((short)1, redacteur, ficheMeta);
            }
            case 2: {
                return RoleUtils.resolveFichePermissionType(((FichePermission)permission.getCustomPermission()).write(), redacteur, ficheMeta);
            }
        }
        return false;
    }

    public static boolean matchStandardPermission(FichePermission fichePermission) {
        return fichePermission.create() && fichePermission.read() == 3 && fichePermission.write() == 1;
    }

    public static String levelToString(short level) {
        switch (level) {
            case 0: {
                return "none";
            }
            case 1: {
                return "standard";
            }
            case 2: {
                return "custom";
            }
            case 3: {
                return "admin";
            }
        }
        throw new IllegalArgumentException("type = " + level);
    }

    public static short levelToShort(String level) {
        switch (level) {
            case "none": {
                return 0;
            }
            case "standard": {
                return 1;
            }
            case "custom": {
                return 2;
            }
            case "admin": {
                return 3;
            }
        }
        throw new IllegalArgumentException("type = " + level);
    }

    public static String fichePermissionTypeToString(short type) {
        switch (type) {
            case 3: {
                return "all";
            }
            case 0: {
                return "none";
            }
            case 1: {
                return "own";
            }
            case 2: {
                return "sphere";
            }
        }
        throw new IllegalArgumentException("type = " + type);
    }

    public static short fichePermissionTypeToShort(String type) {
        if (type.equals("all")) {
            return 3;
        }
        if (type.equals("none")) {
            return 0;
        }
        if (type.equals("own")) {
            return 1;
        }
        if (type.equals("sphere")) {
            return 2;
        }
        throw new IllegalArgumentException("type = " + type);
    }

    public static String permissionSummaryLevelToString(int level) {
        switch (level) {
            case 0: {
                return "none";
            }
            case 1: {
                return "own";
            }
            case 2: {
                return "sphere";
            }
            case 3: {
                return "croisement";
            }
            case 4: {
                return "all";
            }
            case 5: {
                return "admin";
            }
        }
        throw new IllegalArgumentException("level= " + level);
    }

    public static List<Role> wrap(Role[] array) {
        return new RoleList(array);
    }

    public static List<RoleDef.SubsetEntry> wrap(RoleDef.SubsetEntry[] array) {
        return new RoleDefSubsetEntryList(array);
    }

    public static RoleDef.SubsetEntry toSubsetEntry(SubsetKey subsetKey, Permission permission) {
        return new InternalSubsetEntry(subsetKey, permission);
    }

    private static class DefaultPermission
    implements Permission {
        private final short level;
        private final Permission.CustomPermission customPermission;

        private DefaultPermission(short level, Permission.CustomPermission customPermission) {
            this.level = level;
            this.customPermission = customPermission;
        }

        @Override
        public short getLevel() {
            return this.level;
        }

        @Override
        public Permission.CustomPermission getCustomPermission() {
            return this.customPermission;
        }
    }

    private static class DefaultFichePermission
    implements FichePermission {
        private final boolean create;
        private final short read;
        private final short write;

        private DefaultFichePermission(boolean create, short read, short write) {
            this.create = create;
            this.read = read;
            this.write = write;
        }

        @Override
        public boolean create() {
            return this.create;
        }

        @Override
        public short read() {
            return this.read;
        }

        @Override
        public short write() {
            return this.write;
        }
    }

    private static class RoleList
    extends AbstractList<Role>
    implements RandomAccess {
        private final Role[] array;

        private RoleList(Role[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Role get(int index) {
            return this.array[index];
        }
    }

    private static class RoleDefSubsetEntryList
    extends AbstractList<RoleDef.SubsetEntry>
    implements RandomAccess {
        private final RoleDef.SubsetEntry[] array;

        private RoleDefSubsetEntryList(RoleDef.SubsetEntry[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public RoleDef.SubsetEntry get(int index) {
            return this.array[index];
        }
    }

    private static class InternalSubsetEntry
    implements RoleDef.SubsetEntry {
        private final SubsetKey subsetKey;
        private final Permission permission;

        private InternalSubsetEntry(SubsetKey subsetKey, Permission permission) {
            this.subsetKey = subsetKey;
            this.permission = permission;
        }

        @Override
        public SubsetKey getSubsetKey() {
            return this.subsetKey;
        }

        @Override
        public Permission getPermission() {
            return this.permission;
        }
    }

    private static class AllSphereSupervisor
    implements SphereSupervisor {
        private AllSphereSupervisor() {
        }

        @Override
        public boolean allowCoreChange(BdfUser bdfUser, String sphereName) {
            return true;
        }
    }
}

