/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.menu;

import fr.exemole.bdfserver.api.menu.ActionEntry;
import fr.exemole.bdfserver.api.menu.ActionGroup;
import fr.exemole.bdfserver.tools.menu.MenuUtils;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;

public class ActionGroupBuilder {
    private final String id;
    private final List<ActionEntry> entryList = new ArrayList<ActionEntry>();
    private Object titleObject;

    public ActionGroupBuilder(String id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        this.id = id;
    }

    public ActionGroupBuilder setTitle(String title) {
        this.titleObject = title;
        return this;
    }

    public ActionGroupBuilder setTitleMessage(Message titleMessage) {
        this.titleObject = titleMessage;
        return this;
    }

    public ActionGroupBuilder setTitleMessage(String messageKey, Object ... messageValues) {
        this.titleObject = LocalisationUtils.toMessage(messageKey, messageValues);
        return this;
    }

    public ActionGroupBuilder addActionEntry(ActionEntry actionEntry) {
        this.entryList.add(actionEntry);
        return this;
    }

    public boolean isEmpty() {
        return this.entryList.isEmpty();
    }

    public ActionGroup toActionGroup() {
        Object finalTitleObject = this.titleObject;
        if (finalTitleObject == null) {
            finalTitleObject = this.id;
        }
        List<ActionEntry> finalList = MenuUtils.wrap(this.entryList.toArray(new ActionEntry[this.entryList.size()]));
        return new InternalActionGroup(this.id, finalTitleObject, finalList);
    }

    public static ActionGroupBuilder init(String id) {
        return new ActionGroupBuilder(id);
    }

    private static class InternalActionGroup
    implements ActionGroup {
        private final String id;
        private final Object title;
        private final List<ActionEntry> actionEntryList;

        private InternalActionGroup(String id, Object title, List<ActionEntry> actionEntryList) {
            this.id = id;
            this.title = title;
            this.actionEntryList = actionEntryList;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Object getTitle() {
            return this.title;
        }

        @Override
        public List<ActionEntry> getActionEntryList() {
            return this.actionEntryList;
        }
    }
}

