/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.memento.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public final class MementoTreeDOMReader {
    private MementoTreeDOMReader() {
    }

    public static Node readNode(Element element) {
        String name = element.getAttribute("name").trim();
        Node node = new Node(name);
        DOMUtils.readChildren(element, new NodeConsumer(node));
        return node;
    }

    public static class Node {
        private final String name;
        private final List<Node> subnodeList = new ArrayList<Node>();

        private Node(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isLeaf() {
            return this.subnodeList.isEmpty();
        }

        public List<Node> getSubnodeList() {
            return this.subnodeList;
        }

        private void add(Node node) {
            this.subnodeList.add(node);
        }
    }

    private static class NodeConsumer
    implements Consumer<Element> {
        private final Node parentNode;

        private NodeConsumer(Node parentNode) {
            this.parentNode = parentNode;
        }

        @Override
        public void accept(Element element) {
            String name = element.getAttribute("name").trim();
            if (name.length() == 0) {
                return;
            }
            String tagName = element.getTagName();
            if (tagName.equals("leaf")) {
                this.parentNode.add(new Node(name));
            } else if (tagName.equals("branch")) {
                Node subnode = new Node(name);
                NodeConsumer nodeHandler = new NodeConsumer(subnode);
                DOMUtils.readChildren(element, nodeHandler);
                this.parentNode.add(subnode);
            }
        }
    }
}

