/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.instruction;

import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.api.instruction.BdfCommandResult;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.interaction.Domain;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.tools.configuration.PathConfigurationBuilder;
import fr.exemole.bdfserver.tools.instruction.RequestHandler;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.album.Album;
import net.fichotheque.album.Illustration;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.exportation.access.AccessDef;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.exportation.scrutari.ScrutariExportDef;
import net.fichotheque.exportation.sql.SqlExportDef;
import net.fichotheque.exportation.table.TableExportDescription;
import net.fichotheque.exportation.transformation.TemplateContentDescription;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TransformationDescription;
import net.fichotheque.selection.SelectionDef;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.text.RelativePath;

public class OutputRequestHandler
extends RequestHandler
implements OutputParameters {
    private final OutputParameters outputParameters;

    public OutputRequestHandler(OutputParameters outputParameters) {
        super(outputParameters, outputParameters.getRequestMap());
        this.outputParameters = outputParameters;
    }

    @Override
    public Domain getDomain() {
        return this.outputParameters.getDomain();
    }

    @Override
    public String getOutput() {
        return this.outputParameters.getOutput();
    }

    @Override
    public BdfCommandResult getBdfCommandResult() {
        return this.outputParameters.getBdfCommandResult();
    }

    public Corpus getCorpus() throws ErrorMessageException {
        FicheMeta ficheMeta;
        Corpus corpus = (Corpus)this.getResultObject("obj.corpus");
        if (corpus == null && (ficheMeta = (FicheMeta)this.getResultObject("obj.fichemeta")) != null) {
            corpus = ficheMeta.getCorpus();
        }
        if (corpus == null) {
            corpus = this.getMandatoryCorpus();
        }
        this.checkSubsetAccess(corpus);
        return corpus;
    }

    public Thesaurus getThesaurus() throws ErrorMessageException {
        Motcle motcle;
        Thesaurus thesaurus = (Thesaurus)this.getResultObject("obj.thesaurus");
        if (thesaurus == null && (motcle = (Motcle)this.getResultObject("obj.motcle")) != null) {
            thesaurus = motcle.getThesaurus();
        }
        if (thesaurus == null) {
            thesaurus = this.getMandatoryThesaurus();
        }
        this.checkSubsetAccess(thesaurus);
        return thesaurus;
    }

    public Addenda getAddenda() throws ErrorMessageException {
        Document document;
        Addenda addenda = (Addenda)this.getResultObject("obj.addenda");
        if (addenda == null && (document = (Document)this.getResultObject("obj.document")) != null) {
            addenda = document.getAddenda();
        }
        if (addenda == null) {
            addenda = this.getMandatoryAddenda();
        }
        this.checkSubsetAccess(addenda);
        return addenda;
    }

    public Album getAlbum() throws ErrorMessageException {
        Illustration illustration;
        Album album = (Album)this.getResultObject("obj.album");
        if (album == null && (illustration = (Illustration)this.getResultObject("obj.illustration")) != null) {
            album = illustration.getAlbum();
        }
        if (album == null) {
            album = this.getMandatoryAlbum();
        }
        this.checkSubsetAccess(album);
        return album;
    }

    public Sphere getSphere() throws ErrorMessageException {
        Redacteur redacteur;
        Sphere sphere = (Sphere)this.getResultObject("obj.sphere");
        if (sphere == null && (redacteur = (Redacteur)this.getResultObject("obj.redacteur")) != null) {
            sphere = redacteur.getSphere();
        }
        if (sphere == null) {
            sphere = this.getMandatorySphere();
        }
        this.checkSubsetAccess(sphere);
        return sphere;
    }

    public FicheMeta getFicheMeta() throws ErrorMessageException {
        FicheMeta ficheMeta = (FicheMeta)this.getResultObject("obj.fichemeta");
        if (ficheMeta == null) {
            ficheMeta = this.getMandatoryFicheMeta(true);
        }
        return ficheMeta;
    }

    public Illustration getIllustration() throws ErrorMessageException {
        Illustration illustration = (Illustration)this.getResultObject("obj.illustration");
        if (illustration == null) {
            illustration = this.getMandatoryIllustration();
        }
        return illustration;
    }

    public Document getDocument() throws ErrorMessageException {
        Document document = (Document)this.getResultObject("obj.document");
        if (document == null) {
            document = this.getMandatoryDocument();
        }
        return document;
    }

    public Redacteur getRedacteur() throws ErrorMessageException {
        Redacteur redacteur = (Redacteur)this.getResultObject("obj.redacteur");
        if (redacteur == null) {
            redacteur = this.getMandatoryRedacteur();
        }
        return redacteur;
    }

    public Motcle getMotcle() throws ErrorMessageException {
        Motcle motcle = (Motcle)this.getResultObject("obj.motcle");
        if (motcle == null) {
            motcle = this.getMandatoryMotcle();
        }
        return motcle;
    }

    public Role getRole() throws ErrorMessageException {
        Role role = (Role)this.getResultObject("obj.role");
        if (role == null) {
            role = this.getMandatoryRole();
        }
        return role;
    }

    public SelectionDef getSelectionDef() throws ErrorMessageException {
        SelectionDef selectionDefDef = (SelectionDef)this.getResultObject("obj.selectiondef");
        if (selectionDefDef == null) {
            selectionDefDef = this.getMandatorySelectionDef();
        }
        return selectionDefDef;
    }

    public ScrutariExportDef getScrutariExportDef() throws ErrorMessageException {
        ScrutariExportDef scrutariExportDef = (ScrutariExportDef)this.getResultObject("obj.scrutariexportdef");
        if (scrutariExportDef == null) {
            scrutariExportDef = this.getMandatoryScrutariExportDef();
        }
        return scrutariExportDef;
    }

    public SqlExportDef getSqlExportDef() throws ErrorMessageException {
        SqlExportDef sqlExportDef = (SqlExportDef)this.getResultObject("obj.sqlexportdef");
        if (sqlExportDef == null) {
            sqlExportDef = this.getMandatorySqlExportDef();
        }
        return sqlExportDef;
    }

    public AccessDef getAccessDef() throws ErrorMessageException {
        AccessDef accessDef = (AccessDef)this.getResultObject("obj.accessdef");
        if (accessDef == null) {
            accessDef = this.getMandatoryAccessDef();
        }
        return accessDef;
    }

    public TableExportDescription getTableExportDescription() throws ErrorMessageException {
        TableExportDescription tableExportDescription = (TableExportDescription)this.getResultObject("obj.tableexportdescription");
        if (tableExportDescription == null) {
            tableExportDescription = this.getMandatoryTableExportDescription();
        }
        return tableExportDescription;
    }

    public TransformationDescription getTransformationDescription() throws ErrorMessageException {
        TransformationDescription transformationDescription = (TransformationDescription)this.getResultObject("obj.transformationdescription");
        if (transformationDescription == null) {
            transformationDescription = this.getMandatoryTransformationDescription();
        }
        return transformationDescription;
    }

    public TemplateDescription getTemplateDescription() throws ErrorMessageException {
        TemplateDescription templateDescription = (TemplateDescription)this.getResultObject("obj.templatedescription");
        if (templateDescription == null) {
            templateDescription = this.getMandatoryTemplateDescription();
        }
        return templateDescription;
    }

    public PathConfiguration getPathConfiguration() {
        PathConfiguration pathConfiguration = (PathConfiguration)this.getResultObject("obj.pathconfiguration");
        if (pathConfiguration == null) {
            pathConfiguration = PathConfigurationBuilder.build(this.getBdfServer());
        }
        return pathConfiguration;
    }

    public BalayageDescription getBalayageDescription() throws ErrorMessageException {
        BalayageDescription balayageDescription = (BalayageDescription)this.getResultObject("obj.templatedescription");
        if (balayageDescription == null) {
            balayageDescription = this.getMandatoryBalayageDescription();
        }
        return balayageDescription;
    }

    public TemplateContentDescription getTemplateContentDescription() throws ErrorMessageException {
        TemplateContentDescription templateContentDescription = (TemplateContentDescription)this.getResultObject("obj.templatecontentdescription");
        if (templateContentDescription == null) {
            TemplateDescription templateDescription = (TemplateDescription)this.getResultObject("obj.templatedescription");
            if (templateDescription == null) {
                templateDescription = this.getMandatoryTemplateDescription();
            }
            templateContentDescription = this.getMandatoryTemplateContentDescription(templateDescription);
        }
        return templateContentDescription;
    }

    public BalayageDescription getBalayage() throws ErrorMessageException {
        BalayageDescription balayageDescription = (BalayageDescription)this.getResultObject("obj.templatedescription");
        if (balayageDescription == null) {
            balayageDescription = this.getMandatoryBalayageDescription();
        }
        return balayageDescription;
    }

    public RelativePath getRelativePath() throws ErrorMessageException {
        RelativePath path = (RelativePath)this.getResultObject("obj.relativepath");
        if (path == null) {
            path = this.getMandatoryRelativePath();
        }
        return path;
    }

    public static OutputRequestHandler init(OutputParameters outputParameters) {
        return new OutputRequestHandler(outputParameters);
    }
}

