/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.instruction;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.exportation.table.FicheTableParameters;
import fr.exemole.bdfserver.api.instruction.BdfCommandParameters;
import fr.exemole.bdfserver.api.instruction.BdfCommandResult;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.instruction.TypedBdfInstruction;
import fr.exemole.bdfserver.api.interaction.Domain;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.tools.exportation.table.BdfTableExportUtils;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.ResultJsonProducer;
import fr.exemole.bdfserver.tools.interaction.PropertiesParam;
import java.text.ParseException;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.utils.TableExportUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.LangPreferenceBuilder;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.CommandMessageJsonProducer;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.request.RequestUtils;
import net.mapeadores.util.servlets.ResponseHandler;

public final class BdfInstructionUtils {
    public static final BdfInstruction NOTFOUND_BDFINSTRUCTION = new NotFoundBdfInstruction();

    private BdfInstructionUtils() {
    }

    public static MessageLocalisation getMessageLocalisation(RequestMap requestMap, BdfServer bdfServer, @Nullable UserLangContext userLangContext) {
        if (userLangContext != null) {
            return bdfServer.getL10nManager().getMessageLocalisation(userLangContext);
        }
        return bdfServer.getL10nManager().getMessageLocalisation(BdfInstructionUtils.getLangPreference(requestMap, bdfServer));
    }

    public static LangPreference getLangPreference(RequestMap requestMap, BdfServer bdfServer) {
        LangPreferenceBuilder langPreferenceBuilder = new LangPreferenceBuilder();
        RequestUtils.checkLangPreference(requestMap, langPreferenceBuilder);
        ConfigurationUtils.checkLangPreference(bdfServer.getLangConfiguration(), langPreferenceBuilder);
        return langPreferenceBuilder.addLang(Lang.build("fr")).toLangPreference();
    }

    public static SubsetItem checkMasterSubsetItem(Corpus corpus, int id, BdfUser bdfUser) throws ErrorMessageException {
        Subset masterSubset = corpus.getMasterSubset();
        if (masterSubset != null) {
            SubsetItem masterSubsetItem = masterSubset.getSubsetItemById(id);
            if (masterSubsetItem == null) {
                throw BdfErrors.error("_ error.unknown.mastersubsetitem", id, masterSubset.getSubsetKeyString());
            }
            return masterSubsetItem;
        }
        return null;
    }

    public static boolean checkConfirmation(RequestMap requestMap, BdfServer bdfServer) {
        String checkConfirmation = requestMap.getParameter("confirmationcheck");
        if (checkConfirmation == null) {
            return false;
        }
        return checkConfirmation.equals("ok");
    }

    public static String getFicheGetLink(FicheMeta ficheMeta, String extension) {
        return "fiches/" + ficheMeta.getSubsetName() + "-" + String.valueOf(ficheMeta.getId()) + "." + extension;
    }

    public static String getFicheGetLink(FicheMeta ficheMeta, String extension, String name) {
        return "fiches/" + ficheMeta.getSubsetName() + "-" + String.valueOf(ficheMeta.getId()) + "-" + name + "." + extension;
    }

    public static String getCompilationGetLink(String extension) {
        return "fiches/compilation." + extension;
    }

    public static String getCompilationGetLink(String extension, String name) {
        return "fiches/_compilation-" + name + "." + extension;
    }

    public static String getExtensionDomain(String registrationName) {
        return Domain.getCompleteDomain("ext", registrationName);
    }

    public static boolean ownsToExtension(BdfCommandParameters bdfCommandParameters, String registrationName) {
        return BdfInstructionUtils.isExtensionDomain(bdfCommandParameters.getDomain(), registrationName);
    }

    public static boolean ownsToExtension(OutputParameters parameters, String registrationName) {
        return BdfInstructionUtils.isExtensionDomain(parameters.getDomain(), registrationName);
    }

    public static boolean isExtensionDomain(Domain domain, String registrationName) {
        return domain.getFirstPart().equals("ext") && domain.getSecondPart().equals(registrationName);
    }

    public static String getAbsolutePageName(String domain, String page) {
        return domain + ":" + page;
    }

    public static String getAbsoluteCommandName(String domain, String commandName) {
        return domain + ":" + commandName;
    }

    public static String getPageOutput(String pageName) {
        return "page|" + pageName;
    }

    public static String getStreamOutput(String streamName) {
        return "stream|" + streamName;
    }

    public static String getJsonOutput(String jsonName) {
        return "json|" + jsonName;
    }

    public static boolean isJsonOutput(BdfInstruction bdfInstruction) {
        if (bdfInstruction instanceof TypedBdfInstruction) {
            return ((TypedBdfInstruction)bdfInstruction).getOutputType() == 2;
        }
        return false;
    }

    public static String getPhraseParamPrefix(String phraseName) {
        return "phrase_" + phraseName + "/";
    }

    public static CellConverter getCellConverter(OutputParameters outputParameters) {
        return BdfInstructionUtils.getCellConverter(outputParameters, false);
    }

    public static CellConverter getCellConverter(OutputParameters outputParameters, boolean noDefault) {
        BdfServer bdfServer = outputParameters.getBdfServer();
        PropertiesParam propertiesParam = PropertiesParam.fromRequest(outputParameters.getRequestMap());
        CellConverter cellConverter = null;
        block6 : switch (propertiesParam.getType()) {
            case "special": {
                switch (propertiesParam.getName()) {
                    case "phrases": {
                        cellConverter = TableExportUtils.getPhraseConverter(outputParameters.getWorkingLang(), outputParameters.getFormatLocale());
                        break block6;
                    }
                    case "table": {
                        OutputRequestHandler outputRequestHandler = new OutputRequestHandler(outputParameters);
                        Corpus corpus = BdfInstructionUtils.getOptionalCorpus(outputRequestHandler);
                        String patternMode = BdfInstructionUtils.getPatternMode(outputRequestHandler);
                        SubsetKey contextCorpusKey = null;
                        try {
                            contextCorpusKey = SubsetKey.parse((short)1, outputRequestHandler.getParameter("contextcorpus", false));
                        }
                        catch (ParseException | ErrorMessageException exception) {
                            // empty catch block
                        }
                        cellConverter = BdfTableExportUtils.getSpecialTableCellConverter(outputParameters, contextCorpusKey, patternMode, corpus);
                        break block6;
                    }
                }
                break;
            }
            case "tableexport": {
                ExtractionContext extractionContext = outputParameters.getDefaultExtractionContext();
                cellConverter = BdfTableExportUtils.getCellConverterFromName(bdfServer, extractionContext, propertiesParam.getName());
                break;
            }
            case "components": {
                OutputRequestHandler outputRequestHandler = new OutputRequestHandler(outputParameters);
                Corpus corpus = BdfInstructionUtils.getOptionalCorpus(outputRequestHandler);
                String patternMode = BdfInstructionUtils.getPatternMode(outputRequestHandler);
                cellConverter = BdfTableExportUtils.getComponentsCellConverter(outputParameters, propertiesParam.getComponentNameList(), patternMode, corpus);
            }
        }
        if (cellConverter == null && !noDefault) {
            cellConverter = TableExportUtils.EMPTY_CELLCONVERTER;
        }
        return cellConverter;
    }

    private static Corpus getOptionalCorpus(OutputRequestHandler outputRequestHandler) {
        try {
            return outputRequestHandler.getMandatoryCorpus();
        }
        catch (ErrorMessageException eme) {
            return null;
        }
    }

    private static String getPatternMode(OutputRequestHandler outputRequestHandler) {
        String patternMode = outputRequestHandler.getTrimedParameter("patternmode");
        if (patternMode.isEmpty()) {
            return "label";
        }
        try {
            return FicheTableParameters.checkPatternMode(patternMode);
        }
        catch (IllegalArgumentException iae) {
            return "label";
        }
    }

    public static JsonProducer getDefaultJsonProducer(MessageLocalisation messageLocalisation, BdfCommandResult bdfCommandResult, CommandMessage errorMessage) {
        if (bdfCommandResult != null && errorMessage != null) {
            CommandMessage mainCommandMessage = bdfCommandResult.getCommandMessage();
            if (mainCommandMessage != null) {
                return new CommandMessageJsonProducer(messageLocalisation, mainCommandMessage, errorMessage);
            }
            return new CommandMessageJsonProducer(messageLocalisation, errorMessage);
        }
        if (bdfCommandResult != null) {
            return new ResultJsonProducer(bdfCommandResult, messageLocalisation);
        }
        return new CommandMessageJsonProducer(messageLocalisation, errorMessage);
    }

    private static class NotFoundBdfInstruction
    implements BdfInstruction {
        private NotFoundBdfInstruction() {
        }

        @Override
        public short getBdfUserNeed() {
            return 1;
        }

        @Override
        public ResponseHandler runInstruction(BdfUser bdfUser) {
            return null;
        }
    }
}

