/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.importation.engines;

import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.importation.engines.LiensImportEngine;
import java.text.ParseException;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.importation.ParentChange;
import net.fichotheque.importation.ThesaurusImport;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ParentRecursivityException;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.tools.FichothequeTools;
import net.fichotheque.tools.thesaurus.ThesaurusTools;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.localisation.Langs;

public final class ThesaurusImportEngine {
    private ThesaurusImportEngine() {
    }

    public static void runThesaurusImport(EditSession editSession, BdfParameters bdfParameters, ThesaurusImport thesaurusImport) {
        switch (thesaurusImport.getType()) {
            case "edit": {
                ThesaurusImportEngine.runEdit(editSession, bdfParameters, thesaurusImport);
                break;
            }
            case "remove": {
                ThesaurusImportEngine.runRemove(editSession, thesaurusImport);
                break;
            }
            case "merge": {
                ThesaurusImportEngine.runMerge(editSession, thesaurusImport);
                break;
            }
            case "move": {
                ThesaurusImportEngine.runMove(editSession, thesaurusImport);
            }
        }
    }

    private static void runEdit(EditSession editSession, BdfParameters bdfParameters, ThesaurusImport thesaurusImport) {
        EditEngine editEngine = new EditEngine(editSession.getFichothequeEditor(), thesaurusImport.getThesaurus(), bdfParameters.getPermissionSummary());
        for (ThesaurusImport.MotcleImport motcleImport : thesaurusImport.getMotcleImportList()) {
            if (!(motcleImport instanceof ThesaurusImport.EditMotcleImport)) continue;
            editEngine.edit((ThesaurusImport.EditMotcleImport)motcleImport);
        }
    }

    private static void runRemove(EditSession editSession, ThesaurusImport thesaurusImport) {
        Thesaurus thesaurus = thesaurusImport.getThesaurus();
        FichothequeEditor fichothequeEditor = editSession.getFichothequeEditor();
        int resultCount = 0;
        for (ThesaurusImport.MotcleImport motcleImport : thesaurusImport.getMotcleImportList()) {
            boolean done;
            Motcle motcle = thesaurus.getMotcleById(motcleImport.getMotcleId());
            if (motcle == null || !(done = FichothequeTools.remove(fichothequeEditor, motcle))) continue;
            ++resultCount;
        }
    }

    private static void runMerge(EditSession editSession, ThesaurusImport thesaurusImport) {
        Thesaurus thesaurus = thesaurusImport.getThesaurus();
        FichothequeEditor fichothequeEditor = editSession.getFichothequeEditor();
        int resultCount = 0;
        for (ThesaurusImport.MotcleImport motcleImport : thesaurusImport.getMotcleImportList()) {
            ThesaurusImport.MergeMotcleImport mergeMotcleImport = (ThesaurusImport.MergeMotcleImport)motcleImport;
            Motcle motcle = thesaurus.getMotcleById(motcleImport.getMotcleId());
            if (motcle == null) continue;
            try {
                Langs langs = editSession.getBdfServer().getThesaurusLangChecker().getAuthorizedLangs(mergeMotcleImport.getDestinationMotcle().getThesaurus());
                ThesaurusTools.merge(fichothequeEditor, motcle, mergeMotcleImport.getDestinationMotcle(), langs);
                ++resultCount;
            }
            catch (ParentRecursivityException parentRecursivityException) {}
        }
    }

    private static void runMove(EditSession editSession, ThesaurusImport thesaurusImport) {
        Thesaurus thesaurus = thesaurusImport.getThesaurus();
        FichothequeEditor fichothequeEditor = editSession.getFichothequeEditor();
        Thesaurus destinationThesaurus = thesaurusImport.getDestinationThesaurus();
        Langs langs = editSession.getBdfServer().getThesaurusLangChecker().getAuthorizedLangs(destinationThesaurus);
        for (ThesaurusImport.MotcleImport motcleImport : thesaurusImport.getMotcleImportList()) {
            Motcle motcle = thesaurus.getMotcleById(motcleImport.getMotcleId());
            if (motcle == null) continue;
            ThesaurusTools.move(fichothequeEditor, motcle, destinationThesaurus, langs);
        }
    }

    private static class EditEngine {
        private final FichothequeEditor fichothequeEditor;
        private final Thesaurus thesaurus;
        private final ThesaurusEditor thesaurusEditor;
        private final PermissionSummary permissionSummary;
        private final boolean withIdalpha;

        private EditEngine(FichothequeEditor fichothequeEditor, Thesaurus thesaurus, PermissionSummary permissionSummary) {
            this.fichothequeEditor = fichothequeEditor;
            this.thesaurus = thesaurus;
            this.thesaurusEditor = fichothequeEditor.getThesaurusEditor(thesaurus);
            this.permissionSummary = permissionSummary;
            this.withIdalpha = thesaurus.isIdalphaType();
        }

        private void edit(ThesaurusImport.EditMotcleImport motcleImport) {
            Motcle motcle = null;
            int id = motcleImport.getMotcleId();
            if (id > 0) {
                motcle = this.thesaurus.getMotcleById(id);
            }
            String newIdalpha = motcleImport.getNewIdalpha();
            if (motcle == null) {
                if (this.withIdalpha) {
                    if (newIdalpha == null) {
                        return;
                    }
                } else {
                    newIdalpha = null;
                }
                try {
                    motcle = this.thesaurusEditor.createMotcle(id, newIdalpha);
                }
                catch (ParseException | ExistingIdException exception) {}
            } else if (this.withIdalpha && newIdalpha != null) {
                try {
                    this.thesaurusEditor.setIdalpha(motcle, newIdalpha);
                }
                catch (ParseException | ExistingIdException exception) {
                    // empty catch block
                }
            }
            if (motcle != null) {
                this.edit(motcle, motcleImport);
            }
        }

        private void edit(Motcle motcle, ThesaurusImport.EditMotcleImport motcleImport) {
            ThesaurusUtils.changeMotcleLabels(this.thesaurusEditor, motcle, motcleImport.getLabelChange());
            this.fichothequeEditor.changeAttributes(motcle, motcleImport.getAttributeChange());
            String newStatus = motcleImport.getNewStatus();
            if (newStatus != null) {
                this.thesaurusEditor.setStatus(motcle, newStatus);
            }
            CroisementEditor croisementEditor = this.fichothequeEditor.getCroisementEditor();
            LiensImportEngine.run(croisementEditor, motcle, motcleImport.getLiensImport(), this.permissionSummary);
            ParentChange parentChange = motcleImport.getParentChange();
            if (parentChange != null) {
                if (parentChange instanceof ParentChange.Thesaurus) {
                    try {
                        this.thesaurusEditor.setParent(motcle, null);
                    }
                    catch (ParentRecursivityException parentRecursivityException) {}
                } else {
                    Motcle parentMotcle = null;
                    if (parentChange instanceof ParentChange.Id) {
                        parentMotcle = this.thesaurus.getMotcleById(((ParentChange.Id)parentChange).getParentId());
                    } else if (parentChange instanceof ParentChange.Idalpha) {
                        parentMotcle = this.thesaurus.getMotcleByIdalpha(((ParentChange.Idalpha)parentChange).getParentIdalpha());
                    }
                    if (parentMotcle != null) {
                        try {
                            this.thesaurusEditor.setParent(motcle, parentMotcle);
                        }
                        catch (ParentRecursivityException parentRecursivityException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

