/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ficheform;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.FormElement;
import fr.exemole.bdfserver.api.ficheform.FormElementProvider;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import fr.exemole.bdfserver.tools.ficheform.builders.AddendaIncludeElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.AlbumIncludeElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.CorpusIncludeElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.GeopointProprieteSubfieldsElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.ImageProprieteSubfieldsElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.LangFieldElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.MontantInformationSubfieldsElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.MontantProprieteSubfieldsElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.PersonneProprieteSubfieldElementBuilder;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.CorpusMetadataUtils;

public final class FormElementProviderFactory {
    private FormElementProviderFactory() {
    }

    public static FormElementProvider newInstance(OutputParameters outputParameters) {
        return FormElementProviderFactory.newInstance(FicheFormUtils.toFicheFormParameters(outputParameters));
    }

    public static FormElementProvider newInstance(FicheFormParameters ficheFormParameters) {
        return new InternalFormElementProvider(ficheFormParameters);
    }

    private static class InternalFormElementProvider
    implements FormElementProvider {
        private final FicheFormParameters ficheFormParameters;

        public InternalFormElementProvider(FicheFormParameters ficheFormParameters) {
            this.ficheFormParameters = ficheFormParameters;
        }

        @Override
        public FormElement.Include getFormElement(FichePointeur fichePointeur, IncludeUi includeUi) {
            if (includeUi instanceof SpecialIncludeUi) {
                SpecialIncludeUi specialIncludeUi = (SpecialIncludeUi)includeUi;
                if (!FicheFormUtils.hasAccess(this.ficheFormParameters, specialIncludeUi)) {
                    return null;
                }
                switch (specialIncludeUi.getName()) {
                    case "liage": {
                        CorpusIncludeElementBuilder cieb = CorpusIncludeElementBuilder.check(fichePointeur, this.ficheFormParameters, specialIncludeUi);
                        if (cieb != null) {
                            return cieb.toCorpusIncludeElement();
                        }
                        return null;
                    }
                    case "parentage": {
                        return null;
                    }
                }
                return null;
            }
            if (includeUi instanceof SubsetIncludeUi) {
                SubsetIncludeUi subsetIncludeUi = (SubsetIncludeUi)includeUi;
                if (!FicheFormUtils.hasAccess(this.ficheFormParameters, subsetIncludeUi)) {
                    return null;
                }
                switch (subsetIncludeUi.getCategory()) {
                    case 4: {
                        AddendaIncludeElementBuilder adieb = AddendaIncludeElementBuilder.check(fichePointeur, this.ficheFormParameters, subsetIncludeUi);
                        if (adieb != null) {
                            return adieb.toAddendaIncludeElement();
                        }
                        return null;
                    }
                    case 5: {
                        AlbumIncludeElementBuilder alieb = AlbumIncludeElementBuilder.check(fichePointeur, this.ficheFormParameters, subsetIncludeUi);
                        if (alieb != null) {
                            return alieb.toAlbumIncludeElement();
                        }
                        return null;
                    }
                    case 1: {
                        CorpusIncludeElementBuilder cieb = CorpusIncludeElementBuilder.check(fichePointeur, this.ficheFormParameters, subsetIncludeUi);
                        if (cieb != null) {
                            return cieb.toCorpusIncludeElement();
                        }
                        return null;
                    }
                    case 2: {
                        return FicheFormUtils.toThesaurusIncludeElement(fichePointeur, this.ficheFormParameters, subsetIncludeUi);
                    }
                }
                return null;
            }
            return null;
        }

        @Override
        public FormElement.Field getFormElement(FichePointeur fichePointeur, FieldUi fieldUi) {
            Object builder;
            CorpusField corpusField = FicheFormUtils.getCorpusField(fichePointeur, fieldUi);
            if (corpusField == null) {
                return null;
            }
            if (corpusField.isGenerated()) {
                return null;
            }
            if (!FicheFormUtils.hasAccess(this.ficheFormParameters, fieldUi)) {
                return null;
            }
            switch (corpusField.getFieldString()) {
                case "id": {
                    return null;
                }
                case "lang": {
                    return LangFieldElementBuilder.build(fichePointeur, this.ficheFormParameters, corpusField, fieldUi).toLangFieldElement();
                }
            }
            if (corpusField.isPropriete() && corpusField.isSubfieldDisplay()) {
                switch (corpusField.getFicheItemType()) {
                    case 2: {
                        builder = PersonneProprieteSubfieldElementBuilder.check(fichePointeur, this.ficheFormParameters, corpusField, fieldUi);
                        if (builder != null) {
                            return ((PersonneProprieteSubfieldElementBuilder)builder).toPersonneProprieteSubfieldsElement();
                        }
                        return null;
                    }
                    case 10: {
                        builder = GeopointProprieteSubfieldsElementBuilder.check(fichePointeur, this.ficheFormParameters, corpusField, fieldUi);
                        if (builder != null) {
                            return ((GeopointProprieteSubfieldsElementBuilder)builder).toGeopointProprieteSubfieldsElement();
                        }
                        return null;
                    }
                    case 12: {
                        builder = ImageProprieteSubfieldsElementBuilder.check(fichePointeur, this.ficheFormParameters, corpusField, fieldUi);
                        if (builder != null) {
                            return ((ImageProprieteSubfieldsElementBuilder)builder).toImageProprieteSubfieldsElement();
                        }
                        return null;
                    }
                }
            }
            if (CorpusMetadataUtils.isCurrenciesPropriete(corpusField)) {
                builder = MontantProprieteSubfieldsElementBuilder.check(fichePointeur, this.ficheFormParameters, corpusField, fieldUi);
                if (builder != null) {
                    return ((MontantProprieteSubfieldsElementBuilder)builder).toMontantProprieteSubfieldsElement();
                }
                return null;
            }
            if (CorpusMetadataUtils.isCurrenciesInformation(corpusField)) {
                builder = MontantInformationSubfieldsElementBuilder.check(fichePointeur, this.ficheFormParameters, corpusField, fieldUi);
                if (builder != null) {
                    return ((MontantInformationSubfieldsElementBuilder)builder).toMontantInformationSubfieldsElement();
                }
                return null;
            }
            return FicheFormUtils.toFormElement(fichePointeur, this.ficheFormParameters, corpusField, fieldUi);
        }
    }
}

