/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.storage.TemplateStorage;
import fr.exemole.bdfserver.tools.exportation.transformation.BdfTransformationUtils;
import fr.exemole.bdfserver.tools.exportation.transformation.DefaultExtractionDefFactory;
import fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates.DefaultOptions;
import fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates.DefaultTemplateUtils;
import fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates.SimpleFicheXsltWriter;
import fr.exemole.bdfserver.tools.storage.TemplateStorageUnitBuilder;
import java.io.IOException;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.exportation.transformation.TemplateDef;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.tools.exportation.transformation.TemplateDefBuilder;
import net.fichotheque.utils.TransformationUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.xml.XsltWriter;

class XsltHtmlUnit {
    private XsltHtmlUnit() {
    }

    static TemplateStorage.Unit build(BdfServer bdfServer, TemplateKey templateKey, DefaultOptions options, Attributes initAttributes) {
        ExtractionDef extractionDef;
        String xslt;
        if (!templateKey.isSimpleTemplate()) {
            throw new IllegalArgumentException("templateKey is not a simple template key");
        }
        TransformationKey transformationKey = templateKey.getTransformationKey();
        TemplateDef templateDef = TemplateDefBuilder.init(templateKey, initAttributes).toTemplateDef();
        if (transformationKey.isCorpusTransformationKey()) {
            xslt = XsltHtmlUnit.getFicheXslt(bdfServer, transformationKey, initAttributes);
        } else {
            switch (transformationKey.getKeyString()) {
                case "compilation": {
                    xslt = XsltHtmlUnit.getFicheXslt(bdfServer, transformationKey, initAttributes);
                    break;
                }
                case "section": 
                case "format": {
                    xslt = XsltHtmlUnit.getResourceTransformationXslt(bdfServer, transformationKey);
                    break;
                }
                default: {
                    xslt = XsltHtmlUnit.getIncludeTransformationXslt(transformationKey);
                }
            }
        }
        TemplateStorageUnitBuilder builder = TemplateStorageUnitBuilder.init("xslt", templateDef);
        builder.addStorageContent("transformer.xsl", xslt);
        if (options.withExtractionDef() && (extractionDef = DefaultExtractionDefFactory.newInstance(bdfServer, transformationKey, initAttributes)) != null) {
            String extractionContent = DefaultTemplateUtils.getExtractionDefXML(extractionDef, options.compactStyle());
            builder.addStorageContent("extraction.xml", extractionContent);
        }
        return builder.toTemplateStorageUnit();
    }

    private static String getResourceTransformationXslt(BdfServer bdfServer, TransformationKey transformationKey) {
        RelativePath path = RelativePath.build("xslt/v2/transformations/html/" + transformationKey + ".xsl");
        return bdfServer.getResourceStorages().getResourceDocStream(path).getContent();
    }

    private static String getIncludeTransformationXslt(TransformationKey transformationKey) {
        StringBuilder buf = new StringBuilder();
        XsltWriter xsltWriter = new XsltWriter();
        xsltWriter.setAppendable(buf);
        xsltWriter.setIndentLength(0);
        try {
            xsltWriter.appendXMLDeclaration();
            xsltWriter.openXslStyleSheet();
            xsltWriter.addXslInclude("bdf://this/xslt/v2/transformations/html/" + transformationKey + ".xsl");
            xsltWriter.closeXslStyleSheet();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    private static String getFicheXslt(BdfServer bdfServer, TransformationKey transformationKey, Attributes attributes) {
        int extractVersion = TransformationUtils.getExtractVersion(attributes);
        StringBuilder buf = new StringBuilder();
        SimpleFicheXsltWriter ficheXsltWriter = new SimpleFicheXsltWriter(bdfServer, extractVersion);
        ficheXsltWriter.setAppendable(buf);
        try {
            ficheXsltWriter.appendXMLDeclaration();
            ficheXsltWriter.openXslStyleSheet();
            if (transformationKey.isCorpusTransformationKey()) {
                ficheXsltWriter.addXslInclude("bdf://this/xslt/v2/transformations/html/fiche.xsl");
                SubsetKey corpusKey = transformationKey.toCorpusKey();
                Corpus corpus = (Corpus)bdfServer.getFichotheque().getSubset(corpusKey);
                ficheXsltWriter.add(corpus, false);
            } else {
                ficheXsltWriter.addXslInclude("bdf://this/xslt/v2/transformations/html/compilation.xsl");
                for (Corpus corpus : BdfTransformationUtils.getCorpusList(bdfServer.getFichotheque(), attributes)) {
                    ficheXsltWriter.add(corpus, true);
                }
            }
            ficheXsltWriter.closeXslStyleSheet();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }
}

