/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.table;

import fr.exemole.bdfserver.api.exportation.table.FicheTableParameters;
import fr.exemole.bdfserver.api.exportation.table.TableExportParameters;
import fr.exemole.bdfserver.tools.exportation.table.BdfTableExportUtils;
import net.fichotheque.exportation.table.TableExportConstants;

public class TableExportParametersBuilder {
    private String tableExportName = null;
    private String headerType = "columntitle";
    private FicheTableParameters ficheTableParameters = BdfTableExportUtils.NONE_FICHETABLEPARAMETERS;

    public TableExportParametersBuilder setTableExportName(String tableExportName) {
        this.tableExportName = tableExportName;
        return this;
    }

    public TableExportParametersBuilder setHeaderType(String headerType) {
        TableExportConstants.checkHeaderType(headerType);
        this.headerType = headerType;
        return this;
    }

    public TableExportParametersBuilder setFicheTableParameters(FicheTableParameters ficheTableParameters) {
        if (ficheTableParameters == null) {
            throw new IllegalArgumentException("ficheTableParameters is null");
        }
        this.ficheTableParameters = ficheTableParameters;
        return this;
    }

    public TableExportParameters toTableExportParameters() {
        return new InternalTableExportParameters(this.tableExportName, this.headerType, this.ficheTableParameters);
    }

    public static TableExportParametersBuilder init() {
        return new TableExportParametersBuilder();
    }

    private static class InternalTableExportParameters
    implements TableExportParameters {
        private final String tableExportName;
        private final String headerType;
        private final FicheTableParameters ficheTableParameters;

        private InternalTableExportParameters(String tableExportName, String headerType, FicheTableParameters ficheTableParameters) {
            this.tableExportName = tableExportName;
            this.headerType = headerType;
            this.ficheTableParameters = ficheTableParameters;
        }

        @Override
        public String getTableExportName() {
            return this.tableExportName;
        }

        @Override
        public FicheTableParameters getDefaulFicheTableParameters() {
            return this.ficheTableParameters;
        }

        @Override
        public String getHeaderType() {
            return this.headerType;
        }
    }
}

