/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.table;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.exportation.table.FicheTableParameters;
import fr.exemole.bdfserver.api.namespaces.CellSpace;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.exportation.table.BdfColDefs;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.exportation.table.FormatColDef;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.exportation.table.TableDefItem;
import net.fichotheque.format.FormatSourceKey;
import net.fichotheque.format.SubsetPathKey;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.thesaurus.metadata.ThesaurusLangChecker;
import net.fichotheque.tools.format.FichothequeFormatDefBuilder;
import net.fichotheque.utils.TableDefUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.attr.Attribute;

public final class DefaultTableDefFactory {
    private DefaultTableDefFactory() {
    }

    public static TableDef fromUi(BdfServer bdfServer, Corpus corpus, FicheTableParameters ficheTableParameters, PermissionSummary permissionSummary) {
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        String patternMode = ficheTableParameters.getPatternMode();
        Fichotheque fichotheque = corpus.getFichotheque();
        SubsetPathKey masterPath = DefaultTableDefFactory.getMasterPath(corpus, permissionSummary);
        ArrayList<TableDefItem> tableDefItemList = new ArrayList<TableDefItem>();
        tableDefItemList.add(BdfColDefs.corpusField(FichothequeFormatDefBuilder.init(), corpusMetadata.getCorpusField(FieldKey.ID), patternMode));
        if (ficheTableParameters.isWith("chrono")) {
            tableDefItemList.add(BdfColDefs.chrono(FichothequeFormatDefBuilder.init(), "date_creation", patternMode));
            tableDefItemList.add(BdfColDefs.chrono(FichothequeFormatDefBuilder.init(), "date_modification", patternMode));
        }
        UiComponents uiComponents = bdfServer.getUiManager().getMainUiComponents(corpus);
        for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
            Subset otherSubset;
            SubsetIncludeUi includeUi;
            ExtendedIncludeKey extendedIncludeKey;
            FichothequeFormatDefBuilder formatDefBuilder = new FichothequeFormatDefBuilder();
            if (uiComponent instanceof FieldUi) {
                CorpusField corpusField;
                Object fieldUi = (FieldUi)uiComponent;
                FieldKey fieldKey = fieldUi.getFieldKey();
                if (!ficheTableParameters.isWith("section") && fieldKey.isSection() || (corpusField = corpusMetadata.getCorpusField(fieldKey)) == null) continue;
                tableDefItemList.add(BdfColDefs.corpusField(formatDefBuilder, corpusField, patternMode));
                continue;
            }
            if (uiComponent instanceof SpecialIncludeUi) {
                switch (uiComponent.getName()) {
                    case "liage": {
                        if (!ficheTableParameters.isWith("corpusinclude")) break;
                        tableDefItemList.add(BdfColDefs.liage(formatDefBuilder, patternMode));
                    }
                }
                continue;
            }
            if (!(uiComponent instanceof SubsetIncludeUi) || !DefaultTableDefFactory.testInclude(ficheTableParameters, extendedIncludeKey = (includeUi = (SubsetIncludeUi)uiComponent).getExtendedIncludeKey()) || (otherSubset = bdfServer.getFichotheque().getSubset(extendedIncludeKey.getSubsetKey())) == null || !permissionSummary.hasAccess(otherSubset)) continue;
            tableDefItemList.add(BdfColDefs.subsetIncludeField(formatDefBuilder, extendedIncludeKey, patternMode, fichotheque, masterPath));
        }
        return TableDefUtils.toTableDef(tableDefItemList);
    }

    public static TableDef fromComponentList(BdfServer bdfServer, Corpus corpus, List<UiComponent> componentList, String patternMode, PermissionSummary permissionSummary) {
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        Fichotheque fichotheque = corpus.getFichotheque();
        SubsetPathKey masterPath = DefaultTableDefFactory.getMasterPath(corpus, permissionSummary);
        ArrayList<TableDefItem> tableDefItemList = new ArrayList<TableDefItem>();
        for (UiComponent uiComponent : componentList) {
            FichothequeFormatDefBuilder formatDefBuilder = new FichothequeFormatDefBuilder();
            DefaultTableDefFactory.checkAttributes(formatDefBuilder, uiComponent);
            if (uiComponent instanceof FieldUi) {
                Object fieldUi = (FieldUi)uiComponent;
                FieldKey fieldKey = fieldUi.getFieldKey();
                CorpusField corpusField = corpusMetadata.getCorpusField(fieldKey);
                if (corpusField == null) continue;
                tableDefItemList.add(BdfColDefs.corpusField(formatDefBuilder, corpusField, patternMode));
                continue;
            }
            if (uiComponent instanceof SpecialIncludeUi) {
                switch (uiComponent.getName()) {
                    case "liage": {
                        tableDefItemList.add(BdfColDefs.liage(formatDefBuilder, patternMode));
                    }
                }
                continue;
            }
            if (!(uiComponent instanceof SubsetIncludeUi)) continue;
            SubsetIncludeUi includeUi = (SubsetIncludeUi)uiComponent;
            ExtendedIncludeKey extendedIncludeKey = includeUi.getExtendedIncludeKey();
            Subset otherSubset = bdfServer.getFichotheque().getSubset(extendedIncludeKey.getSubsetKey());
            if (otherSubset == null || !permissionSummary.hasAccess(otherSubset)) continue;
            tableDefItemList.add(BdfColDefs.subsetIncludeField(formatDefBuilder, extendedIncludeKey, patternMode, fichotheque, masterPath));
        }
        return TableDefUtils.toTableDef(tableDefItemList);
    }

    public static TableDef fromThesaurusMetadata(Thesaurus thesaurus, ThesaurusLangChecker thesaurusLangChecker) {
        ArrayList<TableDefItem> tableDefItemList = new ArrayList<TableDefItem>();
        List<ThesaurusFieldKey> coreList = ThesaurusUtils.computeCoreFieldList(thesaurus, thesaurusLangChecker);
        for (ThesaurusFieldKey thesaurusFieldKey : coreList) {
            FichothequeFormatDefBuilder formatDefBuilder = new FichothequeFormatDefBuilder();
            formatDefBuilder.addSource(FormatSourceKey.newThesaurusFieldKeyInstance(thesaurusFieldKey));
            if (DefaultTableDefFactory.castToInteger(thesaurusFieldKey)) {
                formatDefBuilder.setCastType((short)1);
            }
            FormatColDef colDef = TableDefUtils.toFormatColDef(thesaurusFieldKey.toString(), formatDefBuilder.toFichothequeFormatDef());
            tableDefItemList.add(colDef);
        }
        return TableDefUtils.toTableDef(tableDefItemList);
    }

    private static boolean castToInteger(ThesaurusFieldKey thesaurusFieldKey) {
        if (thesaurusFieldKey.equals(ThesaurusFieldKey.ID)) {
            return true;
        }
        if (thesaurusFieldKey.equals(ThesaurusFieldKey.PARENT_ID)) {
            return true;
        }
        return thesaurusFieldKey.equals(ThesaurusFieldKey.LEVEL);
    }

    private static boolean testInclude(FicheTableParameters ficheTableParameters, ExtendedIncludeKey extendedIncludeKey) {
        switch (extendedIncludeKey.getCategory()) {
            case 4: {
                return ficheTableParameters.isWith("addendainclude");
            }
            case 5: {
                return ficheTableParameters.isWith("albuminclude");
            }
            case 1: {
                return ficheTableParameters.isWith("corpusinclude");
            }
            case 2: {
                return ficheTableParameters.isWith("thesaurusinclude");
            }
        }
        return false;
    }

    private static SubsetPathKey getMasterPath(Corpus corpus, PermissionSummary permissionSummary) {
        Subset masterSubset = corpus.getMasterSubset();
        if (masterSubset != null && masterSubset instanceof Thesaurus && permissionSummary.hasAccess(masterSubset)) {
            return SubsetPathKey.newParentagePath(masterSubset.getSubsetKey());
        }
        return null;
    }

    private static void checkAttributes(FichothequeFormatDefBuilder formatDefBuilder, UiComponent uiComponent) {
        Attribute cellFormat = uiComponent.getAttributes().getAttribute(CellSpace.FORMAT_KEY);
        if (cellFormat != null) {
            formatDefBuilder.putStringValue(CellSpace.FORMAT_KEY.toString(), cellFormat.getFirstValue());
        }
    }
}

