/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.balayage.dom;

import fr.exemole.bdfserver.tools.balayage.BalayageBuilder;
import java.text.ParseException;
import net.fichotheque.Fichotheque;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.tools.exportation.balayage.BalayageOutputBuilder;
import net.fichotheque.tools.exportation.balayage.BalayageUnitBuilder;
import net.fichotheque.tools.exportation.balayage.SiteMapOptionBuilder;
import net.fichotheque.tools.selection.SelectionDOMUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.localisation.ListLangContextBuilder;
import net.mapeadores.util.text.AccoladePattern;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BalayageDOMReader {
    private final Fichotheque fichotheque;
    private final BalayageBuilder balayageBuilder;

    public BalayageDOMReader(Fichotheque fichotheque, BalayageBuilder builder) {
        this.fichotheque = fichotheque;
        this.balayageBuilder = builder;
    }

    public void readBalayage(Element element_xml) {
        NodeList liste = element_xml.getChildNodes();
        boolean metadone = false;
        for (int i = 0; i < liste.getLength(); ++i) {
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1) continue;
            Element el = (Element)nd;
            String tagname = el.getTagName();
            if (!metadone && tagname.equals("metadata")) {
                metadone = true;
                this.readMetadata(el);
                continue;
            }
            if (tagname.equals("global-fiche-query") || tagname.equals("global-fiche-select")) {
                FicheQuery ficheQuery = SelectionDOMUtils.getFicheConditionEntry(this.fichotheque, el).getFicheQuery();
                if (ficheQuery.isEmpty()) continue;
                this.balayageBuilder.addGlobalFicheQuery(ficheQuery);
                continue;
            }
            if (tagname.equals("corpus-balayage")) {
                this.addCorpusBalayageUnit(el);
                continue;
            }
            if (tagname.equals("fiche-balayage")) {
                this.addFicheBalayageUnit(el);
                continue;
            }
            if (tagname.equals("thesaurus-balayage")) {
                this.addThesaurusBalayageUnit(el);
                continue;
            }
            if (tagname.equals("motcle-balayage")) {
                this.addMotcleBalayageUnit(el);
                continue;
            }
            if (tagname.equals("unique-balayage")) {
                this.addUniqueBalayageUnit(el);
                continue;
            }
            if (tagname.equals("document-balayage")) {
                this.addDocumentBalayageUnit(el);
                continue;
            }
            if (tagname.equals("illustration-balayage") || tagname.equals("album-balayage")) {
                this.addIllustrationBalayageUnit(el);
                continue;
            }
            if (tagname.equals("sitemap")) {
                this.setSiteMapOption(el);
                continue;
            }
            if (!tagname.equals("postscriptum")) continue;
            this.initPostscriptum(el);
        }
    }

    private void initPostscriptum(Element element_xml) {
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            String sql;
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1) continue;
            Element el = (Element)nd;
            String tagname = el.getTagName();
            if (tagname.equals("command")) {
                String command = XMLUtils.getData(el);
                if (command.length() <= 0) continue;
                this.balayageBuilder.addPostscriptumExternalScript(command);
                continue;
            }
            if (tagname.equals("scrutari")) {
                String scrutari = XMLUtils.getData(el);
                if (scrutari.length() <= 0) continue;
                this.balayageBuilder.addPostscriptumScrutariExport(scrutari);
                continue;
            }
            if (!tagname.equals("sql") || (sql = XMLUtils.getData(el)).length() <= 0) continue;
            this.balayageBuilder.addPostscriptumSqlExport(sql);
        }
    }

    public void readIncludeCatalog(Element element_xml) {
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            Element el;
            String tagname;
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1 || !(tagname = (el = (Element)nd).getTagName()).equals("fragment")) continue;
            String string = el.getAttribute("key");
        }
    }

    private void setSiteMapOption(Element element_xml) {
        SiteMapOptionBuilder siteMapOptionBuilder = new SiteMapOptionBuilder();
        siteMapOptionBuilder.setBaseUrl(element_xml.getAttribute("base-url"));
        siteMapOptionBuilder.setPath(element_xml.getAttribute("path"));
        siteMapOptionBuilder.setFileName(element_xml.getAttribute("file-name"));
        this.balayageBuilder.setSiteMapOption(siteMapOptionBuilder.toSiteMapOption());
    }

    private void readMetadata(Element element_xml) {
        Lang[] langArray;
        String param;
        String path;
        String root = element_xml.getAttribute("root");
        if (root.length() > 0) {
            this.balayageBuilder.setRootName(root);
        }
        if ((path = element_xml.getAttribute("path")).length() > 0) {
            this.balayageBuilder.setPath(path);
        }
        if ((param = element_xml.getAttribute("transform")).equals("false")) {
            this.balayageBuilder.setWithTransformation(false);
        } else {
            this.balayageBuilder.setWithTransformation(true);
        }
        String postCommand = element_xml.getAttribute("post-command").trim();
        if (postCommand.length() > 0) {
            this.balayageBuilder.addPostscriptumExternalScript(postCommand);
        }
        String defaultLangOption = element_xml.getAttribute("default-lang-option");
        try {
            this.balayageBuilder.setDefaultLangOption(defaultLangOption);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String langs = element_xml.getAttribute("langs");
        if (langs.length() > 0 && (langArray = LangsUtils.toCleanLangArray(langs)).length > 0) {
            this.balayageBuilder.setLangContext(ListLangContextBuilder.build(langArray));
        }
    }

    private void addCorpusBalayageUnit(Element element_xml) {
        BalayageUnitBuilder balayageUnitBuilder = this.balayageBuilder.addBalayageUnitBuilder("corpus");
        this.commonBalayageUnit(balayageUnitBuilder, element_xml);
        balayageUnitBuilder.setFicheQuery(SelectionDOMUtils.getFicheConditionEntry(this.fichotheque, element_xml).getFicheQuery());
    }

    private void addFicheBalayageUnit(Element element_xml) {
        BalayageUnitBuilder balayageUnitBuilder = this.balayageBuilder.addBalayageUnitBuilder("fiche");
        this.commonBalayageUnit(balayageUnitBuilder, element_xml);
        balayageUnitBuilder.setFicheQuery(SelectionDOMUtils.getFicheConditionEntry(this.fichotheque, element_xml).getFicheQuery());
    }

    private void addThesaurusBalayageUnit(Element element_xml) {
        BalayageUnitBuilder balayageUnitBuilder = this.balayageBuilder.addBalayageUnitBuilder("thesaurus");
        this.commonBalayageUnit(balayageUnitBuilder, element_xml);
        balayageUnitBuilder.setMotcleQuery(SelectionDOMUtils.getMotcleConditionEntry(this.fichotheque, element_xml).getMotcleQuery());
    }

    private void addMotcleBalayageUnit(Element element_xml) {
        BalayageUnitBuilder balayageUnitBuilder = this.balayageBuilder.addBalayageUnitBuilder("motcle");
        this.commonBalayageUnit(balayageUnitBuilder, element_xml);
        balayageUnitBuilder.setMotcleQuery(SelectionDOMUtils.getMotcleConditionEntry(this.fichotheque, element_xml).getMotcleQuery());
    }

    private void addUniqueBalayageUnit(Element element_xml) {
        BalayageUnitBuilder balayageUnitBuilder = this.balayageBuilder.addBalayageUnitBuilder("unique");
        this.commonBalayageUnit(balayageUnitBuilder, element_xml);
    }

    private void addDocumentBalayageUnit(Element element_xml) {
        BalayageUnitBuilder balayageUnitBuilder = this.balayageBuilder.addBalayageUnitBuilder("document");
        this.commonBalayageUnit(balayageUnitBuilder, element_xml);
        balayageUnitBuilder.setFicheQuery(SelectionDOMUtils.getFicheConditionEntry(this.fichotheque, element_xml).getFicheQuery());
        balayageUnitBuilder.setDocumentQuery(SelectionDOMUtils.getDocumentConditionEntry(element_xml).getDocumentQuery());
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            String extension;
            Element el;
            String tagname;
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1 || !(tagname = (el = (Element)nd).getTagName()).equals("extension") || (extension = XMLUtils.getData(el)).length() <= 0) continue;
            balayageUnitBuilder.addExtension(extension);
        }
    }

    private void addIllustrationBalayageUnit(Element element_xml) {
        BalayageUnitBuilder balayageUnitBuilder = this.balayageBuilder.addBalayageUnitBuilder("illustration");
        this.commonBalayageUnit(balayageUnitBuilder, element_xml);
        balayageUnitBuilder.setIllustrationQuery(SelectionDOMUtils.getIllustrationConditionEntry(element_xml).getIllustrationQuery());
    }

    private void commonBalayageUnit(BalayageUnitBuilder balayageUnitBuilder, Element element_xml) {
        String[] tokens;
        balayageUnitBuilder.setName(element_xml.getAttribute("name")).setExtractionPath(element_xml.getAttribute("extraction"));
        String globalselect = element_xml.getAttribute("global-select");
        if (globalselect.equals("false")) {
            balayageUnitBuilder.setGlobalSelect(false);
        }
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            Element el;
            String tagname;
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1 || !(tagname = (el = (Element)nd).getTagName()).equals("output")) continue;
            BalayageOutputBuilder outputBuilder = balayageUnitBuilder.addOutputBuilder();
            this.parseOutput(el, outputBuilder);
        }
        String mode = element_xml.getAttribute("mode");
        for (String token : tokens = StringUtils.getTechnicalTokens(mode, true)) {
            balayageUnitBuilder.addMode(token);
        }
    }

    private void parseOutput(Element element_xml, BalayageOutputBuilder outputBuilder) {
        String path;
        String langs;
        String posttransform;
        String mode;
        outputBuilder.setName(element_xml.getAttribute("name"));
        String xsltPath = element_xml.getAttribute("xslt");
        if (xsltPath.length() > 0) {
            outputBuilder.setXsltPath(xsltPath);
        }
        if ((mode = element_xml.getAttribute("mode")).length() > 0) {
            outputBuilder.setMode(mode);
        }
        if ((posttransform = element_xml.getAttribute("posttransform")).length() > 0) {
            outputBuilder.setPosttransform(posttransform);
        }
        boolean cleanBefore = StringUtils.isTrue(element_xml.getAttribute("clean"));
        outputBuilder.setCleanBefore(cleanBefore);
        String patternString = element_xml.getAttribute("pattern");
        if (patternString.length() > 0) {
            try {
                AccoladePattern pattern = new AccoladePattern(patternString);
                outputBuilder.setPattern(pattern);
            }
            catch (ParseException pattern) {
                // empty catch block
            }
        }
        if ((langs = element_xml.getAttribute("langs")).length() > 0) {
            Langs langs2 = LangsUtils.toCleanLangs(langs);
        }
        if ((path = this.normalizePath(element_xml.getAttribute("path"))) != null) {
            if (path.equals("_inc_/")) {
                outputBuilder.setIncludeOutput(true);
            } else {
                outputBuilder.setIncludeOutput(false);
                try {
                    AccoladePattern outputPathPattern = new AccoladePattern(path);
                    outputBuilder.setOutputPathPattern(outputPathPattern);
                }
                catch (ParseException outputPathPattern) {
                    // empty catch block
                }
            }
        }
        String langOption = element_xml.getAttribute("lang-option");
        try {
            outputBuilder.setLangOption(langOption);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            String name;
            Element el;
            String tagname;
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1 || !(tagname = (el = (Element)nd).getTagName()).equals("param") || (name = el.getAttribute("name")).length() <= 0) continue;
            String value = el.getAttribute("value");
            outputBuilder.addOutputParam(name, value);
        }
    }

    private String normalizePath(String path) {
        int length = path.length();
        if (length == 0) {
            return null;
        }
        if (path.charAt(0) == '/') {
            return this.normalizePath(path.substring(1));
        }
        char lastChar = path.charAt(length - 1);
        if (lastChar != '/') {
            path = path + '/';
        }
        return path;
    }
}

