/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.tools;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.conf.ConfDirs;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.storage.directory.StorageDirectoryUtils;
import fr.exemole.bdfserver.storage.directory.bdfdata.BdfdataStorageFileCatalog;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChangeBuilder;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.Phrases;
import net.mapeadores.util.text.PhrasesBuilder;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetadataExtractor {
    private MetadataExtractor() {
    }

    public static Result getPhrases(ConfDirs confDirs) {
        StorageDirectory storageDirectoriy = StorageDirectoryUtils.toStorageDirectory(confDirs, "bdfdata");
        StorageFile storageFile = BdfdataStorageFileCatalog.fichothequeMetadata(storageDirectoriy);
        if (!storageFile.exists()) {
            return null;
        }
        try {
            ResultBuilder resultBuilder = new ResultBuilder();
            Document document = storageFile.readDocument();
            DOMUtils.readChildren(document.getDocumentElement(), new RootConsumer(resultBuilder));
            return resultBuilder.toResult();
        }
        catch (BdfStorageException bse) {
            return null;
        }
    }

    private static class ResultBuilder {
        private final Map<Lang, Label> labelMap = new LinkedHashMap<Lang, Label>();
        private final PhrasesBuilder phrasesBuilder = new PhrasesBuilder();

        private ResultBuilder() {
        }

        private void addLabel(Label label) {
            this.labelMap.put(label.getLang(), label);
        }

        private LabelChangeBuilder getPhraseBuilder(String name) {
            return this.phrasesBuilder.getPhraseBuilder(name);
        }

        private Result toResult() {
            return new Result(LabelUtils.toLabels(this.labelMap), this.phrasesBuilder.toPhrases());
        }
    }

    private static class RootConsumer
    implements Consumer<Element> {
        private final ResultBuilder resultBuilder;

        private RootConsumer(ResultBuilder resultBuilder) {
            this.resultBuilder = resultBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("label")) {
                try {
                    Label label = LabelUtils.readLabel(element);
                    if (label != null) {
                        this.resultBuilder.addLabel(label);
                    }
                }
                catch (ParseException label) {}
            } else if (tagName.equals("phrase")) {
                String name = element.getAttribute("name");
                if (!name.isEmpty()) {
                    DOMUtils.readChildren(element, new PhraseLabelConsumer(this.resultBuilder.getPhraseBuilder(name)));
                }
            } else if (tagName.equals("attr")) {
                // empty if block
            }
        }
    }

    public static class Result {
        private final Labels titleLabels;
        private final Phrases phrases;

        private Result(Labels titleLabels, Phrases phrases) {
            this.titleLabels = titleLabels;
            this.phrases = phrases;
        }

        public Labels getTitleLabels() {
            return this.titleLabels;
        }

        public Phrases getPhrases() {
            return this.phrases;
        }
    }

    private static class PhraseLabelConsumer
    implements Consumer<Element> {
        private final LabelChangeBuilder labelChangeBuilder;

        private PhraseLabelConsumer(LabelChangeBuilder labelChangeBuilder) {
            this.labelChangeBuilder = labelChangeBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("label")) {
                try {
                    Label label = LabelUtils.readLabel(element);
                    if (label != null) {
                        this.labelChangeBuilder.putLabel(label);
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }
}

