/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.oldversions;

import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.configuration.LangConfiguration;
import fr.exemole.bdfserver.tools.configuration.LangConfigurationBuilder;
import java.text.ParseException;
import java.util.function.Consumer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class ConfigurationManagerDOMReader {
    private final MessageHandler messageHandler;
    private BdfServerEditor bdfServerEditor;

    public ConfigurationManagerDOMReader(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void readConfigurationManager(BdfServerEditor bdfServerEditor, Element element) {
        this.bdfServerEditor = bdfServerEditor;
        DOMUtils.readChildren(element, new RootConsumer());
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lang-config")) {
                LangConfigConsumer langConfigConsumer = new LangConfigConsumer();
                DOMUtils.readChildren(element, langConfigConsumer);
                ConfigurationManagerDOMReader.this.bdfServerEditor.setLangConfiguration(langConfigConsumer.toLangConfiguration());
            } else {
                DomMessages.unknownTagWarning(ConfigurationManagerDOMReader.this.messageHandler, tagName);
            }
        }
    }

    private class LangConfigConsumer
    implements Consumer<Element> {
        private final LangConfigurationBuilder langConfigurationBuilder = new LangConfigurationBuilder();

        private LangConfigConsumer() {
            this.langConfigurationBuilder.setAllLanguages(false);
        }

        public LangConfiguration toLangConfiguration() {
            return this.langConfigurationBuilder.toLangConfiguration();
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("all-languages")) {
                this.langConfigurationBuilder.setAllLanguages(true);
            } else if (tagName.equals("with-original-name")) {
                this.langConfigurationBuilder.setWithNonlatin(true);
            } else if (tagName.equals("working-lang")) {
                try {
                    Lang lang = Lang.parse(element.getAttribute("lang"));
                    this.langConfigurationBuilder.addWorkingLang(lang);
                }
                catch (ParseException lang) {}
            } else if (tagName.equals("supplementary-lang")) {
                try {
                    Lang langInteger = Lang.parse(element.getAttribute("lang"));
                    this.langConfigurationBuilder.addSupplementaryLang(langInteger);
                }
                catch (ParseException parseException) {}
            } else if (tagName.equals("without-nom-avant")) {
                this.langConfigurationBuilder.setWithoutSurnameFirst(true);
            } else {
                DomMessages.unknownTagWarning(ConfigurationManagerDOMReader.this.messageHandler, tagName);
            }
        }
    }
}

