/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.jdbm;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import jdbm.RecordManager;
import jdbm.helper.Serializer;
import net.fichotheque.corpus.fiche.Information;
import net.fichotheque.corpus.fiche.Propriete;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.FieldKey;

public final class FieldKeyCoder
implements Serializable {
    private static final ClassSerializer classSerializer = new ClassSerializer();
    private final Map<FieldKey, Integer> codeMap = new HashMap<FieldKey, Integer>();
    private final Map<Integer, FieldKey> fieldKeyMap = new HashMap<Integer, FieldKey>();
    private int lastCode = 0;
    private boolean withChange = false;

    private FieldKeyCoder() {
    }

    public int askForCode(Propriete propriete) {
        FieldKey fieldKey = propriete.getFieldKey();
        Integer itg = this.codeMap.get(fieldKey);
        if (itg == null) {
            itg = this.createCode(fieldKey);
        }
        return itg;
    }

    public int askForCode(Information information) {
        FieldKey fieldKey = information.getFieldKey();
        Integer itg = this.codeMap.get(fieldKey);
        if (itg == null) {
            itg = this.createCode(fieldKey);
        }
        return itg;
    }

    public int askForCode(Section section) {
        FieldKey fieldKey = section.getFieldKey();
        Integer itg = this.codeMap.get(fieldKey);
        if (itg == null) {
            itg = this.createCode(fieldKey);
        }
        return itg;
    }

    public int askForCode(FieldKey fieldKey) {
        Integer itg = this.codeMap.get(fieldKey);
        if (itg == null) {
            itg = this.createCode(fieldKey);
        }
        return itg;
    }

    private Integer createCode(FieldKey fieldKey) {
        ++this.lastCode;
        Integer itg = this.lastCode;
        this.codeMap.put(fieldKey, itg);
        this.fieldKeyMap.put(itg, fieldKey);
        this.withChange = true;
        return itg;
    }

    public FieldKey getFieldKey(int code) {
        return this.fieldKeyMap.get(code);
    }

    public boolean isWithChange() {
        return this.withChange;
    }

    public void save(RecordManager recordManager, String objectName) throws IOException {
        long recordId = recordManager.getNamedObject(objectName);
        recordManager.update(recordId, (Object)this, (Serializer)classSerializer);
        this.withChange = false;
    }

    private void add(FieldKey fieldKey, int code) {
        this.lastCode = Math.max(this.lastCode, code);
        Integer itg = code;
        this.codeMap.put(fieldKey, itg);
        this.fieldKeyMap.put(itg, fieldKey);
    }

    private byte[] serialize() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(output);
        dataOutput.writeInt(this.codeMap.size());
        for (Map.Entry<FieldKey, Integer> entry : this.codeMap.entrySet()) {
            dataOutput.writeUTF(entry.getKey().getKeyString());
            dataOutput.writeInt(entry.getValue());
        }
        dataOutput.flush();
        return output.toByteArray();
    }

    public static FieldKeyCoder init(RecordManager recordManager, String objectName) throws IOException {
        long recordId = recordManager.getNamedObject(objectName);
        if (recordId == 0L) {
            FieldKeyCoder coder = new FieldKeyCoder();
            recordId = recordManager.insert((Object)coder, (Serializer)classSerializer);
            recordManager.setNamedObject(objectName, recordId);
            return coder;
        }
        FieldKeyCoder coder = (FieldKeyCoder)recordManager.fetch(recordId, (Serializer)classSerializer);
        return coder;
    }

    private static class ClassSerializer
    implements Serializer {
        private ClassSerializer() {
        }

        public byte[] serialize(Object obj) throws IOException {
            FieldKeyCoder coder = (FieldKeyCoder)obj;
            return coder.serialize();
        }

        public Object deserialize(byte[] serialized) {
            ByteArrayInputStream input = new ByteArrayInputStream(serialized);
            DataInputStream dataInput = new DataInputStream(input);
            try {
                FieldKeyCoder coder = new FieldKeyCoder();
                int size = dataInput.readInt();
                for (int i = 0; i < size; ++i) {
                    String fieldKeyString = dataInput.readUTF();
                    try {
                        FieldKey fieldKey = FieldKey.parse(fieldKeyString);
                        int code = dataInput.readInt();
                        coder.add(fieldKey, code);
                        continue;
                    }
                    catch (ParseException pe) {
                        throw new BdfStorageException(pe);
                    }
                }
                return coder;
            }
            catch (IOException ioe) {
                throw new BdfStorageException(ioe);
            }
        }
    }
}

