/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.implementations;

import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.storage.directory.bdfdata.Remove;
import fr.exemole.bdfserver.storage.directory.bdfdata.Save;
import fr.exemole.bdfserver.storage.directory.implementations.AddendaDataSourceImpl;
import fr.exemole.bdfserver.storage.directory.implementations.AlbumDataSourceImpl;
import fr.exemole.bdfserver.storage.directory.implementations.CorpusDataSourceImpl;
import fr.exemole.bdfserver.storage.directory.implementations.CroisementDataSourceImpl;
import fr.exemole.bdfserver.storage.directory.implementations.SphereDataSourceImpl;
import fr.exemole.bdfserver.storage.directory.implementations.ThesaurusDataSourceImpl;
import fr.exemole.bdfserver.storage.directory.jdbm.FichothequeJdbm;
import java.io.File;
import net.fichotheque.EditOrigin;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.impl.AddendaDataSource;
import net.fichotheque.impl.AlbumDataSource;
import net.fichotheque.impl.CorpusDataSource;
import net.fichotheque.impl.CroisementDataSource;
import net.fichotheque.impl.FichothequeDataSource;
import net.fichotheque.impl.SphereDataSource;
import net.fichotheque.impl.ThesaurusDataSource;
import net.fichotheque.metadata.FichothequeMetadata;

public class FichothequeDataSourceImpl
implements FichothequeDataSource {
    private final StorageDirectory bdfdataDirectory;
    private final AddendaDataSourceImpl addendaDataSourceImpl;
    private final AlbumDataSourceImpl albumDataSourceImpl;
    private final CorpusDataSourceImpl corpusDataSourceImpl;
    private final SphereDataSourceImpl sphereDataSourceImpl;
    private final ThesaurusDataSourceImpl thesaurusDataSourceImpl;
    private final CroisementDataSourceImpl croisementDataSourceImpl;

    public FichothequeDataSourceImpl(StorageDirectory bdfdataDirectory, File cacheDir, FichothequeJdbm fichothequeJdbm) {
        this.bdfdataDirectory = bdfdataDirectory;
        this.addendaDataSourceImpl = new AddendaDataSourceImpl(bdfdataDirectory);
        this.albumDataSourceImpl = new AlbumDataSourceImpl(bdfdataDirectory, cacheDir);
        this.corpusDataSourceImpl = new CorpusDataSourceImpl(bdfdataDirectory, fichothequeJdbm);
        this.sphereDataSourceImpl = new SphereDataSourceImpl(bdfdataDirectory);
        this.thesaurusDataSourceImpl = new ThesaurusDataSourceImpl(bdfdataDirectory);
        this.croisementDataSourceImpl = new CroisementDataSourceImpl(bdfdataDirectory);
    }

    @Override
    public AddendaDataSource getAddendaDataSource() {
        return this.addendaDataSourceImpl;
    }

    @Override
    public AlbumDataSource getAlbumDataSource() {
        return this.albumDataSourceImpl;
    }

    @Override
    public CorpusDataSource getCorpusDataSource() {
        return this.corpusDataSourceImpl;
    }

    @Override
    public SphereDataSource getSphereDataSource() {
        return this.sphereDataSourceImpl;
    }

    @Override
    public ThesaurusDataSource getThesaurusDataSource() {
        return this.thesaurusDataSourceImpl;
    }

    @Override
    public CroisementDataSource getCroisementDataSource() {
        return this.croisementDataSourceImpl;
    }

    @Override
    public void saveFichothequeMetadata(FichothequeMetadata fichothequeMetadata, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Save.saveFichothequeMetadata(this.bdfdataDirectory, fichothequeMetadata, editOrigin);
    }

    @Override
    public void removeAddenda(SubsetKey addendaKey, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Remove.removeAddenda(this.bdfdataDirectory, addendaKey, editOrigin);
    }

    @Override
    public void removeAlbum(SubsetKey albumKey, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Remove.removeAlbum(this.bdfdataDirectory, albumKey, editOrigin);
    }

    @Override
    public void removeCorpus(SubsetKey corpusKey, Subset masterSubset, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Remove.removeCorpus(this.bdfdataDirectory, corpusKey, masterSubset, editOrigin);
    }

    @Override
    public void removeSphere(SubsetKey sphereKey, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Remove.removeSphere(this.bdfdataDirectory, sphereKey, editOrigin);
    }

    @Override
    public void removeThesaurus(SubsetKey thesaurusKey, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Remove.removeThesaurus(this.bdfdataDirectory, thesaurusKey, editOrigin);
    }
}

