/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.servlets;

import fr.exemole.bdfserver.conf.WebappDirs;
import fr.exemole.bdfserver.conf.dom.ConfDOMReader;
import fr.exemole.bdfserver.email.SmtpManager;
import fr.exemole.bdfserver.servlets.BDFInitParameters;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.fichotheque.SubsetKey;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.exceptions.InitException;
import net.mapeadores.util.servlets.ServletUtils;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class BDFInitParametersEngine {
    public static final String BDF_CONF_FILE = "bdfConfFile";
    public static final String MULTI_BDF = "multiBdf";
    public static final String DISABLE_LOGIN_PASSWORD = "disableLoginPassword";
    public static final String ALLOW_AUTHENTIFICATION_SHARING = "allowAuthentificationSharing";
    public static final String CENTRAL_SPHERE_LIST = "centralSphereList";
    public static final String SMTP_FILE = "smtpFile";
    public static final String ALLOW_SUBSCRIBE = "allowSubscribe";
    private final ServletContext servletContext;
    private final Map<String, String> parameterMap = new HashMap<String, String>();

    private BDFInitParametersEngine(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private BDFInitParameters populate() {
        this.populateFromServletContext();
        Element confRootElement = this.getConfRootElement();
        this.populateFromConfFile(confRootElement);
        boolean multiBdf = this.getBoolean(MULTI_BDF);
        WebappDirs webappDirs = this.getWebappDirs(confRootElement, multiBdf);
        multiBdf = webappDirs.isMultiBdf();
        boolean loginPasswordDisabled = this.getBoolean(DISABLE_LOGIN_PASSWORD);
        String authenficationSharing = this.getAuthentificationSharing(multiBdf);
        boolean subscribeAllowed = this.getBoolean(ALLOW_SUBSCRIBE);
        List<SubsetKey> centralSphereList = this.getCentralSphereList(multiBdf);
        SmtpManager smtpManager = this.getSmtpManager();
        return new BDFInitParameters(webappDirs, loginPasswordDisabled, authenficationSharing, centralSphereList, smtpManager, subscribeAllowed);
    }

    private void populateFromServletContext() {
        Enumeration e = this.servletContext.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.servletContext.getInitParameter(name);
            if ((value = value.trim()).length() <= 0) continue;
            this.parameterMap.put(name, value);
        }
    }

    private void populateFromConfFile(Element confRootElement) {
        String multiAttribute;
        DOMUtils.readChildren(confRootElement, new ParameterConsumer());
        if (!this.parameterMap.containsKey(MULTI_BDF) && !(multiAttribute = confRootElement.getAttribute("multi").trim()).isEmpty()) {
            this.parameterMap.put(MULTI_BDF, multiAttribute);
        }
    }

    private Element getConfRootElement() {
        File confFile = this.getConfFile();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(confFile);
            return doc.getDocumentElement();
        }
        catch (ParserConfigurationException pce) {
            throw new InitException("ParserConfigurationException : " + pce.getMessage());
        }
        catch (IOException ioe) {
            throw new InitException("IOException when reading bdfConfFile : " + ioe.getMessage() + " / " + confFile.getAbsolutePath());
        }
        catch (SAXException sax) {
            throw new InitException("XML Error when reading bdfConfFile : " + sax.getMessage() + " / " + confFile.getAbsolutePath());
        }
    }

    private File getConfFile() {
        String bdfConfFileParam = ServletUtils.getInitParameter(this.servletContext, BDF_CONF_FILE);
        File confFile = null;
        if (bdfConfFileParam != null && !(confFile = new File(bdfConfFileParam)).exists()) {
            confFile = null;
        }
        if (confFile == null) {
            confFile = ServletUtils.getRealFile(this.servletContext, "/META-INF/bdf-conf.xml");
        }
        if (confFile == null) {
            confFile = ServletUtils.getRealFile(this.servletContext, "/WEB-INF/bdf-conf.xml");
        }
        if (confFile == null) {
            StringBuilder buf = new StringBuilder();
            buf.append("bdfConfFile does not exist : ");
            if (bdfConfFileParam != null) {
                buf.append(bdfConfFileParam);
                buf.append(" | ");
            }
            buf.append("/WEB-INF|META-INF/bdf-conf.xml");
            throw new InitException(buf.toString());
        }
        if (confFile.isDirectory()) {
            throw new InitException("bdfConfFile is a directory : " + confFile.getAbsolutePath());
        }
        return confFile;
    }

    private boolean getBoolean(String name) {
        String value = this.parameterMap.get(name);
        if (value == null) {
            return false;
        }
        switch (value = value.trim().toLowerCase()) {
            case "true": 
            case "on": 
            case "1": {
                return true;
            }
        }
        return false;
    }

    private WebappDirs getWebappDirs(Element confRootElement, boolean multiBdf) {
        String servletContextName = ServletUtils.getServletContextName(this.servletContext);
        File relativeDirectory = ServletUtils.getRealFile(this.servletContext, "/");
        if (relativeDirectory == null) {
            throw new InitException("Unable to find webapps root : /");
        }
        ConfDOMReader reader = new ConfDOMReader(servletContextName, relativeDirectory);
        return reader.readConf(confRootElement, multiBdf);
    }

    private String getAuthentificationSharing(boolean multiBdf) {
        if (!multiBdf) {
            return "none";
        }
        String value = this.parameterMap.get(ALLOW_AUTHENTIFICATION_SHARING);
        if (value == null) {
            return "none";
        }
        switch (value = value.trim().toLowerCase()) {
            case "strict": {
                return "strict";
            }
            case "lax": 
            case "true": 
            case "on": 
            case "1": {
                return "lax";
            }
        }
        return "none";
    }

    private List<SubsetKey> getCentralSphereList(boolean multiBdf) {
        if (!multiBdf) {
            return FichothequeUtils.EMPTY_SUBSETKEYLIST;
        }
        String value = this.parameterMap.get(CENTRAL_SPHERE_LIST);
        if (value == null) {
            return FichothequeUtils.EMPTY_SUBSETKEYLIST;
        }
        String[] tokens = StringUtils.getTechnicalTokens(value, true);
        LinkedHashSet<SubsetKey> subsetKeySet = new LinkedHashSet<SubsetKey>();
        for (String token : tokens) {
            try {
                SubsetKey sphereKey = SubsetKey.parse((short)3, token);
                subsetKeySet.add(sphereKey);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        int size = subsetKeySet.size();
        if (size == 0) {
            return FichothequeUtils.EMPTY_SUBSETKEYLIST;
        }
        return FichothequeUtils.wrap(subsetKeySet.toArray(new SubsetKey[size]));
    }

    private SmtpManager getSmtpManager() {
        File smtpFile = null;
        String smtpFileParam = this.parameterMap.get(SMTP_FILE);
        if (smtpFileParam != null) {
            smtpFile = new File(smtpFileParam);
        } else {
            File oldFile = ServletUtils.getRealFile(this.servletContext, "/WEB-INF/smtp.ini");
            if (oldFile == null) {
                oldFile = ServletUtils.getRealFile(this.servletContext, "/WEB-INF/bdf-smtp.properties");
            }
            if (oldFile != null) {
                smtpFile = oldFile;
            }
        }
        return new SmtpManager(smtpFile);
    }

    public static BDFInitParameters run(ServletContext servletContext) {
        BDFInitParametersEngine engine = new BDFInitParametersEngine(servletContext);
        return engine.populate();
    }

    private class ParameterConsumer
    implements Consumer<Element> {
        private ParameterConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName().toLowerCase();
            if (tagName.equals("parameter")) {
                String name = element.getAttribute("name");
                String value = element.getAttribute("value");
                value = value.trim();
                if (!BDFInitParametersEngine.this.parameterMap.containsKey(name) && value.length() > 0) {
                    BDFInitParametersEngine.this.parameterMap.put(name, value);
                }
            }
        }
    }
}

