/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.jsonproducers.admin;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.tools.synthesis.RedacteurSynthesis;
import fr.exemole.bdfserver.tools.synthesis.SphereSynthesis;
import java.io.IOException;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;

public class PersonJsonProperty
implements JsonProperty {
    private final Multi multi;
    private final SphereSynthesis sphereSynthesis;
    private final RedacteurSynthesis redacteurSynthesis;
    private final Lang lang;

    public PersonJsonProperty(Multi multi, SphereSynthesis sphereSynthesis, RedacteurSynthesis redacteurSynthesis, Lang lang) {
        this.multi = multi;
        this.sphereSynthesis = sphereSynthesis;
        this.redacteurSynthesis = redacteurSynthesis;
        this.lang = lang;
    }

    @Override
    public String getName() {
        return "person";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        String[] fichothequeNameArray = this.sphereSynthesis.getFichothequeNameArray();
        jw.object();
        jw.key("sphereName").value(this.sphereSynthesis.getSphereName());
        jw.key("login").value(this.redacteurSynthesis.getLogin());
        jw.key("completeName").value(this.redacteurSynthesis.getCompleteName());
        jw.key("email").value(this.redacteurSynthesis.getEmail());
        jw.key("statusArray");
        jw.array();
        for (String fichothequeName : fichothequeNameArray) {
            RedacteurSynthesis.FichothequeStatus status = this.redacteurSynthesis.getFichothequeStatus(fichothequeName);
            if (status == null) continue;
            jw.object();
            jw.key("fichothequeName").value(fichothequeName);
            jw.key("fichothequeTitle").value(this.getFichothequeTitle(fichothequeName));
            jw.key("level").value(PersonJsonProperty.getLevelStringCell(status.getLevel()));
            if (status.hasSpecificName()) {
                jw.key("specificName").value(status.getSpecificName());
            }
            if (status.hasSpecificEmail()) {
                jw.key("specificEmail").value(status.getSpecificEmail());
            }
            jw.endObject();
        }
        jw.endArray();
        jw.endObject();
    }

    private String getFichothequeTitle(String fichothequeName) {
        try {
            BdfServer bdfServer = this.multi.getBdfServer(fichothequeName);
            return bdfServer.getFichotheque().getFichothequeMetadata().getTitleLabels().seekLabelString(this.lang, "");
        }
        catch (ErrorMessageException eme) {
            return "";
        }
    }

    private static String getLevelStringCell(String level) {
        switch (level) {
            case "A": {
                return "admin";
            }
            case "C": {
                return "readonly";
            }
            case "D": {
                return "inactive";
            }
        }
        return "user";
    }
}

