/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.impl;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.multi.MultiConf;
import fr.exemole.bdfserver.multi.api.MultiMetadata;
import fr.exemole.bdfserver.multi.api.MultiMetadataEditor;
import fr.exemole.bdfserver.multi.impl.MultiStorageFileCatalog;
import fr.exemole.bdfserver.multi.tools.dom.MultiMetadataDOMReader;
import fr.exemole.bdfserver.multi.xml.MultiMetadataXMLPart;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.ParseException;
import net.fichotheque.EditOrigin;
import net.fichotheque.utils.DefaultMetadata;
import net.fichotheque.utils.DefaultMetadataEditor;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Document;

public class MultiMetadataImpl
extends DefaultMetadata
implements MultiMetadata {
    private final StorageDirectory storageDirectory;
    private Langs workingLangs;
    private String authority;

    public MultiMetadataImpl(StorageDirectory storageDirectory, Langs workingLangs, String authority) {
        this.storageDirectory = storageDirectory;
        this.workingLangs = workingLangs;
        this.authority = authority;
    }

    @Override
    public Langs getWorkingLangs() {
        return this.workingLangs;
    }

    @Override
    public String getAuthority() {
        return this.authority;
    }

    public MultiMetadataEditor getMultiMetadataEditor(EditOrigin editOrigin) {
        return new InternalMultiMetadataEditor(this, editOrigin);
    }

    public boolean saveChanges(MultiMetadataEditor editor) {
        InternalMultiMetadataEditor internalEditor = (InternalMultiMetadataEditor)editor;
        return internalEditor.saveChanges(this.storageDirectory);
    }

    public static MultiMetadataImpl build(StorageDirectory storageDirectory, MultiConf multiConf) {
        MultiMetadataImpl multiMetadata = new MultiMetadataImpl(storageDirectory, LangsUtils.wrap(MultiMetadataImpl.getDefaultLang(multiConf)), MultiMetadataImpl.getDefaultAuthority(multiConf));
        StorageFile storageFile = MultiStorageFileCatalog.multiMetadata(storageDirectory);
        if (storageFile.exists()) {
            Document document = storageFile.readDocument();
            MultiMetadataDOMReader reader = new MultiMetadataDOMReader(multiMetadata.getMultiMetadataEditor(null), (MessageHandler)LogUtils.NULL_MULTIMESSAGEHANDLER);
            reader.read(document.getDocumentElement());
        }
        return multiMetadata;
    }

    private static String getDefaultAuthority(MultiConf multiConf) {
        String authority = multiConf.getParam("authority");
        if (authority != null && !StringUtils.isAuthority(authority)) {
            authority = null;
        }
        if (authority == null) {
            authority = "localhost";
        }
        return authority;
    }

    private static Lang getDefaultLang(MultiConf multiConf) {
        Lang defaultLang = null;
        String langString = multiConf.getParam("lang");
        if (langString != null) {
            try {
                defaultLang = Lang.parse(langString);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (defaultLang == null) {
            defaultLang = Lang.getDefault().getRootLang();
        }
        return defaultLang;
    }

    private static class InternalMultiMetadataEditor
    extends DefaultMetadataEditor
    implements MultiMetadataEditor {
        private final MultiMetadataImpl multiMetadataImpl;
        private final EditOrigin editOrigin;

        private InternalMultiMetadataEditor(MultiMetadataImpl multiMetadataImpl, EditOrigin editOrigin) {
            super(multiMetadataImpl);
            this.multiMetadataImpl = multiMetadataImpl;
            this.editOrigin = editOrigin;
        }

        @Override
        public boolean setWorkingLangs(Langs workingLangs) {
            if (workingLangs.isEmpty()) {
                return false;
            }
            if (LangsUtils.areEquals(this.multiMetadataImpl.workingLangs, workingLangs)) {
                return false;
            }
            this.multiMetadataImpl.workingLangs = workingLangs;
            this.fireChange();
            return true;
        }

        @Override
        public boolean setAuthority(String authority) {
            if (StringUtils.isAuthority(authority)) {
                String currentAuthority = this.multiMetadataImpl.authority;
                if (!currentAuthority.equals(authority)) {
                    this.multiMetadataImpl.authority = authority;
                    this.fireChange();
                    return true;
                }
                return false;
            }
            return false;
        }

        private boolean saveChanges(StorageDirectory storageDirectory) {
            if (this.isWithChanges()) {
                boolean bl;
                block9: {
                    StorageFile storageFile = MultiStorageFileCatalog.multiMetadata(storageDirectory);
                    BufferedWriter buf = storageFile.archiveAndGetWriter(this.editOrigin);
                    try {
                        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
                        xmlWriter.appendXMLDeclaration();
                        MultiMetadataXMLPart multiMetadataXMLPart = new MultiMetadataXMLPart(xmlWriter);
                        multiMetadataXMLPart.appendMultiMetadata(this.multiMetadataImpl);
                        bl = true;
                        if (buf == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (buf != null) {
                                try {
                                    buf.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException ioe) {
                            throw new BdfStorageException(ioe);
                        }
                    }
                    buf.close();
                }
                return bl;
            }
            return false;
        }
    }
}

