/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands;

import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.MultiEditor;
import fr.exemole.bdfserver.multi.api.MultiMetadata;
import fr.exemole.bdfserver.multi.api.MultiMetadataEditor;
import fr.exemole.bdfserver.multi.commands.AbstractMultiCommand;
import fr.exemole.bdfserver.tools.instruction.BdfCommandUtils;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.EditOrigin;
import net.fichotheque.utils.EditOriginUtils;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.StringUtils;

public class MultiMetadataCommand
extends AbstractMultiCommand {
    public static final String COMMAND_NAME = "MultiMetadata";
    public static final String TITLE_PARAMPREFIX = "title/";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    public static final String WORKINGLANGS_PARAMNAME = "workinglangs";
    public static final String AUTHORITY = "authority";

    public MultiMetadataCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        boolean done;
        MultiMetadata metadata;
        Langs workingLangs = this.getWorkingLangs();
        String authority = this.getAuthority();
        LabelChange titleLabelChange = BdfCommandUtils.getLabelChange(this.requestMap, TITLE_PARAMPREFIX, true);
        HashMap<String, LabelChange> phraseChangeMap = new HashMap<String, LabelChange>();
        BdfCommandUtils.populatePhraseLabelChange(this.requestMap, phraseChangeMap);
        String attributes = this.requestMap.getParameter(ATTRIBUTES_PARAMNAME);
        AttributeChange attributeChange = null;
        if (attributes != null) {
            attributeChange = AttributeParser.parse(attributes);
        }
        EditOrigin editOrigin = EditOriginUtils.newEditOrigin("multi-admin/metadata");
        MultiMetadata multiMetadata = metadata = this.multi.getMultiMetadata();
        synchronized (multiMetadata) {
            MultiEditor multiEditor = this.multi.getMultiEditor(editOrigin);
            MultiMetadataEditor multiMetadataEditor = multiEditor.getMultiMetadataEditor();
            done = this.update(multiMetadataEditor, titleLabelChange, phraseChangeMap, attributeChange);
            if (workingLangs != null && multiMetadataEditor.setWorkingLangs(workingLangs)) {
                done = true;
            }
            if (authority != null && multiMetadataEditor.setAuthority(authority)) {
                done = true;
            }
            if (done) {
                multiEditor.saveChanges();
            }
        }
        if (done) {
            return LogUtils.done("_ done.multi.metadata", new Object[0]);
        }
        return null;
    }

    private boolean update(MultiMetadataEditor metadataEditor, LabelChange titleLabelChange, Map<String, LabelChange> phraseChangeMap, AttributeChange attributeChange) {
        boolean done = false;
        if (metadataEditor.changeLabels(null, titleLabelChange)) {
            done = true;
        }
        for (Map.Entry<String, LabelChange> entry : phraseChangeMap.entrySet()) {
            if (!metadataEditor.changeLabels(entry.getKey(), entry.getValue())) continue;
            done = true;
        }
        if (attributeChange != null && metadataEditor.changeAttributes(attributeChange)) {
            done = true;
        }
        return done;
    }

    private String getAuthority() throws ErrorMessageException {
        String authority = this.requestMap.getParameter(AUTHORITY);
        if (authority != null) {
            if ((authority = authority.trim()).isEmpty()) {
                throw new ErrorMessageException("_ error.empty.authority");
            }
            if (!StringUtils.isAuthority(authority)) {
                throw new ErrorMessageException("_ error.wrong.authority", authority);
            }
        }
        return authority;
    }

    private Langs getWorkingLangs() throws ErrorMessageException {
        String workingLangsParam = this.requestMap.getParameter(WORKINGLANGS_PARAMNAME);
        if (workingLangsParam != null) {
            Langs workingLangs = LangsUtils.toCleanLangs(workingLangsParam);
            if (workingLangs.isEmpty()) {
                throw new ErrorMessageException("_ error.empty.workinglang");
            }
            return workingLangs;
        }
        return null;
    }
}

