/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi;

import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.commands.AbstractMultiCommand;
import fr.exemole.bdfserver.multi.commands.MultiMetadataCommand;
import fr.exemole.bdfserver.multi.commands.central.AddToFichothequeCommand;
import fr.exemole.bdfserver.multi.commands.central.CentralEmailChangeCommand;
import fr.exemole.bdfserver.multi.commands.central.CentralPasswordChangeCommand;
import fr.exemole.bdfserver.multi.commands.central.CentralPersonChangeCommand;
import fr.exemole.bdfserver.multi.commands.central.CentralSphereMetadataCommand;
import fr.exemole.bdfserver.multi.commands.central.CentralStatusChangeCommand;
import fr.exemole.bdfserver.multi.commands.central.CentralUserCreationCommand;
import fr.exemole.bdfserver.multi.commands.central.CopyFromFichothequeCommand;
import fr.exemole.bdfserver.multi.commands.central.FichothequeSphereCreateCommand;
import fr.exemole.bdfserver.multi.commands.central.StatusInFichothequeChangeCommand;
import fr.exemole.bdfserver.multi.commands.fichotheque.FichothequeActionCommand;
import fr.exemole.bdfserver.multi.commands.fichotheque.FichothequeCreationCommand;
import fr.exemole.bdfserver.multi.commands.fichotheque.FichothequeDuplicationCommand;
import fr.exemole.bdfserver.multi.commands.fichotheque.FichothequeInitCommand;
import fr.exemole.bdfserver.multi.commands.personmanager.PersonAddCommand;
import fr.exemole.bdfserver.multi.commands.personmanager.PersonChangeCommand;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.mapeadores.util.ini.IniParser;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.request.RequestMapBuilder;
import net.mapeadores.util.text.RelativePath;

public final class MultiCommands {
    private MultiCommands() {
    }

    public static CommandMessage run(Multi multi, RequestMap requestMap) {
        String cmd = requestMap.getParameter("cmd");
        if (cmd == null) {
            return null;
        }
        AbstractMultiCommand command = MultiCommands.getCommand(multi, requestMap, cmd);
        if (command == null) {
            return LogUtils.error("_ error.unknown.parametervalue", "cmd", cmd);
        }
        try {
            return command.doCommand();
        }
        catch (ErrorMessageException eme) {
            return eme.getErrorMessage();
        }
    }

    public static CommandMessage runFromFile(Multi multi, RelativePath relativePath) {
        Path filePath = multi.getMultiDirs().resolveSubPath("var.run", relativePath);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return LogUtils.error("_ error.unknown.file", relativePath.toString());
        }
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            return LogUtils.error("_ error.unsupported.directory", relativePath.toString());
        }
        RequestMapBuilder requestMapBuilder = new RequestMapBuilder();
        try (InputStream is = Files.newInputStream(filePath, new OpenOption[0]);){
            IniParser.parseIni(is, (key, value) -> requestMapBuilder.addParameter((String)key, (String)value));
        }
        catch (IOException ioe) {
            return LogUtils.error("_ error.exception.io_read", ioe.getLocalizedMessage());
        }
        try {
            Files.delete(filePath);
        }
        catch (IOException ioe) {
            return LogUtils.error("_ error.exception.io_delete", ioe.getLocalizedMessage());
        }
        return MultiCommands.run(multi, requestMapBuilder.toRequestMap());
    }

    private static AbstractMultiCommand getCommand(Multi multi, RequestMap requestMap, String cmd) {
        switch (cmd) {
            case "FichothequeCreation": {
                return new FichothequeCreationCommand(multi, requestMap);
            }
            case "FichothequeDuplication": {
                return new FichothequeDuplicationCommand(multi, requestMap);
            }
            case "FichothequeInit": {
                return new FichothequeInitCommand(multi, requestMap);
            }
            case "MultiMetadata": {
                return new MultiMetadataCommand(multi, requestMap);
            }
            case "PersonChange": {
                return new PersonChangeCommand(multi, requestMap);
            }
            case "PersonAdd": {
                return new PersonAddCommand(multi, requestMap);
            }
            case "FichothequeAction": {
                return new FichothequeActionCommand(multi, requestMap);
            }
            case "CopyFromFichotheque": {
                return new CopyFromFichothequeCommand(multi, requestMap);
            }
            case "CentralSphereMetadata": {
                return new CentralSphereMetadataCommand(multi, requestMap);
            }
            case "CentralUserCreation": {
                return new CentralUserCreationCommand(multi, requestMap);
            }
            case "CentralPersonChange": {
                return new CentralPersonChangeCommand(multi, requestMap);
            }
            case "CentralEmailChange": {
                return new CentralEmailChangeCommand(multi, requestMap);
            }
            case "CentralStatusChange": {
                return new CentralStatusChangeCommand(multi, requestMap);
            }
            case "CentralPasswordChange": {
                return new CentralPasswordChangeCommand(multi, requestMap);
            }
            case "AddToFichotheque": {
                return new AddToFichothequeCommand(multi, requestMap);
            }
            case "StatusInFichothequeChange": {
                return new StatusInFichothequeChangeCommand(multi, requestMap);
            }
            case "FichothequeSphereCreate": {
                return new FichothequeSphereCreateCommand(multi, requestMap);
            }
        }
        return null;
    }
}

