/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.pioche;

import java.io.IOException;
import java.util.Collection;
import net.fichotheque.SubsetKey;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProducer;

public class RedacteurArrayJsonProducer
implements JsonProducer {
    private final Collection<Redacteur> redacteurs;
    private final SubsetKey defaultSphereKey;

    public RedacteurArrayJsonProducer(Collection<Redacteur> redacteurs, SubsetKey defaultSphereKey) {
        this.redacteurs = redacteurs;
        this.defaultSphereKey = defaultSphereKey;
    }

    @Override
    public void writeJson(Appendable appendable) throws IOException {
        JSONWriter jw = new JSONWriter(appendable);
        jw.object();
        jw.key("count").value(this.redacteurs.size());
        jw.key("array");
        jw.array();
        for (Redacteur redacteur : this.redacteurs) {
            SubsetKey sphereKey = redacteur.getSubsetKey();
            String code = this.defaultSphereKey != null && sphereKey.equals(this.defaultSphereKey) ? redacteur.getLogin() : redacteur.getBracketStyle();
            jw.object();
            jw.key("sphere").value(sphereKey.getSubsetName());
            jw.key("id").value(redacteur.getId());
            jw.key("login").value(redacteur.getLogin());
            jw.key("code").value(code);
            jw.key("title").value(redacteur.getPersonCore().toBiblioStyle(false));
            jw.key("status").value(redacteur.getStatus());
            jw.endObject();
        }
        jw.endArray();
        jw.endObject();
    }
}

