/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import fr.exemole.bdfserver.tools.ui.components.FieldUiBuilder;
import fr.exemole.bdfserver.tools.ui.components.IncludeUiBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;

class UiComponentsImpl
implements UiComponents {
    private final Map<String, UiComponent> componentUiMap = new HashMap<String, UiComponent>();
    private final Corpus corpus;
    private final List<UiComponent> componentUiList = new ArrayList<UiComponent>();
    private List<UiComponent> cacheList;

    UiComponentsImpl(Corpus corpus) {
        this.corpus = corpus;
    }

    SubsetKey getSubsetKey() {
        return this.corpus.getSubsetKey();
    }

    @Override
    public List<UiComponent> getUiComponentList() {
        List<UiComponent> result = this.cacheList;
        if (result == null) {
            result = this.initCacheList();
        }
        return result;
    }

    @Override
    public UiComponent getUiComponent(String keyString) {
        return this.componentUiMap.get(keyString);
    }

    boolean setPositionArray(String[] positionArray) {
        ArrayList<UiComponent> newList = new ArrayList<UiComponent>();
        HashMap<String, Integer> duplicateMap = new HashMap<String, Integer>();
        for (String token : positionArray) {
            UiComponent componentUi = this.componentUiMap.get(token);
            if (componentUi == null) continue;
            if (!duplicateMap.containsKey(token)) {
                newList.add(componentUi);
                duplicateMap.put(token, 1);
                continue;
            }
            if (!(componentUi instanceof CommentUi)) continue;
            int number = (Integer)duplicateMap.get(token);
            newList.add(UiUtils.cloneCommentUi((CommentUi)componentUi, ++number));
            duplicateMap.put(token, number);
        }
        for (UiComponent componentUi : this.componentUiList) {
            String token = componentUi.getName();
            if (duplicateMap.containsKey(token)) continue;
            newList.add(componentUi);
        }
        this.componentUiList.clear();
        this.componentUiList.addAll(newList);
        this.clearCache();
        return true;
    }

    void populate(Fichotheque fichotheque, CorpusMetadata corpusMetadata, UiComponents mainUiComponents) {
        HashMap<String, Integer> cloneMap = new HashMap<String, Integer>();
        for (UiComponent uiComponent : mainUiComponents.getUiComponentList()) {
            if (uiComponent instanceof FieldUi) {
                FieldUi fieldUi = (FieldUi)uiComponent;
                if (corpusMetadata.getCorpusField(fieldUi.getFieldKey()) == null) continue;
                this.add(fieldUi);
                continue;
            }
            if (uiComponent instanceof SubsetIncludeUi) {
                if (!fichotheque.containsSubset(((SubsetIncludeUi)uiComponent).getSubsetKey())) continue;
                this.add(uiComponent);
                continue;
            }
            if (uiComponent instanceof CommentUi) {
                String name = uiComponent.getName();
                if (!cloneMap.containsKey(name)) {
                    this.add(uiComponent);
                    cloneMap.put(name, 1);
                    continue;
                }
                int number = (Integer)cloneMap.get(name);
                this.componentUiList.add(UiUtils.cloneCommentUi((CommentUi)uiComponent, ++number));
                cloneMap.put(name, number);
                continue;
            }
            this.add(uiComponent);
        }
        this.clearCache();
    }

    void add(UiComponent componentUi) {
        String name = componentUi.getName();
        if (name.equals("id")) {
            return;
        }
        this.componentUiMap.put(name, componentUi);
        this.componentUiList.add(componentUi);
        this.clearCache();
    }

    boolean removeComponentUi(String key, boolean allowsFieldKeyRemove) {
        UiComponent componentUi = this.componentUiMap.get(key);
        if (componentUi == null) {
            return false;
        }
        if (componentUi instanceof FieldUi && !allowsFieldKeyRemove) {
            return false;
        }
        this.componentUiMap.remove(key);
        this.componentUiList.remove(componentUi);
        if (componentUi instanceof CommentUi) {
            boolean done;
            while (done = this.componentUiList.remove(componentUi)) {
            }
        }
        this.clearCache();
        return true;
    }

    boolean putComponentUi(UiComponent componentUi) {
        String key = componentUi.getName();
        if (key.equals("id")) {
            return false;
        }
        if (!this.componentUiMap.containsKey(key)) {
            this.componentUiList.add(componentUi);
        } else {
            int size = this.componentUiList.size();
            for (int i = 0; i < size; ++i) {
                UiComponent otherComponentUi = this.componentUiList.get(i);
                if (!otherComponentUi.getName().equals(key)) continue;
                this.componentUiList.set(i, componentUi);
            }
        }
        this.componentUiMap.put(key, componentUi);
        this.clearCache();
        return true;
    }

    void checkCorpus() {
        CorpusMetadata corpusMetadata = this.corpus.getCorpusMetadata();
        this.checkField(corpusMetadata, FieldKey.TITRE);
        this.checkField(corpusMetadata, FieldKey.SOUSTITRE);
        this.checkField(corpusMetadata, FieldKey.REDACTEURS);
        for (CorpusField corpusField : corpusMetadata.getProprieteList()) {
            this.checkCorpusField(corpusField);
        }
        for (CorpusField corpusField : corpusMetadata.getInformationList()) {
            this.checkCorpusField(corpusField);
        }
        for (CorpusField corpusField : corpusMetadata.getSectionList()) {
            this.checkCorpusField(corpusField);
        }
        this.checkField(corpusMetadata, FieldKey.LANG);
    }

    boolean checkParentage() {
        if (this.corpus.getMasterSubset() != null || !this.corpus.getSatelliteCorpusList().isEmpty()) {
            return this.checkSpecialIncludeUi("parentage");
        }
        if (this.componentUiMap.containsKey("parentage")) {
            this.removeComponentUi("parentage", true);
            return true;
        }
        return false;
    }

    boolean removeAllSubsetInclude(SubsetKey subsetKey) {
        boolean done = false;
        Iterator<UiComponent> it = this.componentUiList.iterator();
        while (it.hasNext()) {
            UiComponent uiComponent = it.next();
            if (!(uiComponent instanceof SubsetIncludeUi) || !((SubsetIncludeUi)uiComponent).getSubsetKey().equals(subsetKey)) continue;
            it.remove();
            this.componentUiMap.remove(uiComponent.getName());
            done = true;
        }
        this.clearCache();
        return done;
    }

    private void checkField(CorpusMetadata corpusMetadata, FieldKey fieldKey) {
        CorpusField corpusField = corpusMetadata.getCorpusField(fieldKey);
        if (corpusField != null) {
            this.checkCorpusField(corpusField);
        }
    }

    private void checkCorpusField(CorpusField corpusField) {
        FieldKey fieldKey = corpusField.getFieldKey();
        if (!this.componentUiMap.containsKey(fieldKey.getKeyString())) {
            FieldUi fieldUi = FieldUiBuilder.init(fieldKey).toFieldUi();
            this.componentUiList.add(fieldUi);
            this.componentUiMap.put(fieldKey.getKeyString(), fieldUi);
        }
        this.clearCache();
    }

    boolean checkSpecialIncludeUi(String name) {
        if (!this.componentUiMap.containsKey(name)) {
            SpecialIncludeUi includeUi = (SpecialIncludeUi)IncludeUiBuilder.initSpecial(name).toIncludeUi();
            this.componentUiList.add(includeUi);
            this.componentUiMap.put(name, includeUi);
            this.clearCache();
            return true;
        }
        return false;
    }

    private void clearCache() {
        this.cacheList = null;
    }

    private synchronized List<UiComponent> initCacheList() {
        List<UiComponent> immutableList = UiUtils.wrap(this.componentUiList.toArray(new UiComponent[this.componentUiList.size()]));
        this.cacheList = immutableList;
        return immutableList;
    }
}

