/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.impl.PermissionManagerImpl;
import fr.exemole.bdfserver.impl.PolicyManagerImpl;
import fr.exemole.bdfserver.tools.L10nUtils;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.FichothequeListener;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.LabelUtils;

class BdfServerFichothequeListener
implements FichothequeListener {
    public static final int CLEAR_DEFAULTTEMPLATES = 16;
    private final BdfServer bdfServer;
    private boolean onMultiChange = false;
    private int multiChangeMask = 0;

    BdfServerFichothequeListener(BdfServer bdfServer) {
        this.bdfServer = bdfServer;
    }

    void buffer() {
        if (!this.onMultiChange) {
            this.onMultiChange = true;
            this.multiChangeMask = 0;
        }
    }

    private void clearDefaultTemplates() {
        if (this.onMultiChange) {
            this.multiChangeMask |= 0x10;
        } else {
            this.bdfServer.getTransformationManager().clearDistTransformer();
        }
    }

    void flush() {
        if ((this.multiChangeMask & 0x10) != 0) {
            this.bdfServer.getTransformationManager().clearDistTransformer();
        }
        this.onMultiChange = false;
        this.multiChangeMask = 0;
    }

    @Override
    public void subsetCreated(FichothequeEditor fichothequeEditor, Subset subset) {
        if (subset instanceof Corpus) {
            Corpus corpus = (Corpus)subset;
            this.initLabel(fichothequeEditor.getCorpusEditor(corpus));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void subsetRemoved(FichothequeEditor fichothequeEditor, SubsetKey subsetKey, Subset masterSubset) {
        try (EditSession session = this.bdfServer.initEditSession(fichothequeEditor.getEditOrigin());){
            BdfServerEditor bdfServerEditor = session.getBdfServerEditor();
            switch (subsetKey.getCategory()) {
                case 2: {
                    PolicyManagerImpl.subsetRemoved(bdfServerEditor, subsetKey);
                    this.clearDefaultTemplates();
                    return;
                }
                case 3: {
                    this.bdfServer.getBdfUserStorage().removeSphere(subsetKey);
                    return;
                }
                case 1: {
                    this.clearDefaultTemplates();
                    return;
                }
            }
            return;
        }
    }

    @Override
    public void subsetItemRemoved(FichothequeEditor fichothequeEditor, Subset subset, int id) {
        try (EditSession session = this.bdfServer.initEditSession(fichothequeEditor.getEditOrigin());){
            if (subset instanceof Sphere) {
                Sphere sphere = (Sphere)subset;
                SubsetKey sphereKey = sphere.getSubsetKey();
                String globalId = FichothequeUtils.toGlobalId(sphereKey, id);
                this.bdfServer.getBdfUserStorage().removeBdfUser(sphere, id);
                this.bdfServer.getPasswordManager().setPassword(globalId, null);
                ((PermissionManagerImpl)this.bdfServer.getPermissionManager()).redacteurRemoved(session.getBdfServerEditor(), globalId);
            }
        }
    }

    @Override
    public void corpusFieldCreated(FichothequeEditor fichothequeEditor, Corpus corpus, CorpusField corpusField) {
        switch (corpusField.getFieldString()) {
            case "soustitre": {
                this.initLabel(fichothequeEditor.getCorpusEditor(corpus), FieldKey.SOUSTITRE);
            }
        }
    }

    @Override
    public void corpusFieldRemoved(FichothequeEditor fichothequeEditor, Corpus corpus, FieldKey fieldKey) {
    }

    @Override
    public void ficheSaved(FichothequeEditor fichothequeEditor, FicheMeta ficheMeta, FicheAPI fiche) {
    }

    @Override
    public void subsetItemCreated(FichothequeEditor fichothequeEditor, SubsetItem subsetItem) {
    }

    private void initLabel(CorpusEditor corpusEditor) {
        this.initLabel(corpusEditor, FieldKey.ID);
        this.initLabel(corpusEditor, FieldKey.LANG);
        this.initLabel(corpusEditor, FieldKey.TITRE);
        this.initLabel(corpusEditor, FieldKey.REDACTEURS);
    }

    private void initLabel(CorpusEditor corpusEditor, FieldKey fieldKey) {
        CorpusField corpusField = corpusEditor.getCorpus().getCorpusMetadata().getCorpusField(fieldKey);
        String messageKey = L10nUtils.getMessageKey(fieldKey);
        for (Lang lang : this.bdfServer.getLangConfiguration().getWorkingLangs()) {
            CleanedString cs;
            MessageLocalisation messageLocalisation = this.bdfServer.getL10nManager().getMessageLocalisation(lang);
            String labelString = messageLocalisation.toString(messageKey);
            if (labelString == null || (cs = CleanedString.newInstance(labelString)) == null) continue;
            corpusEditor.getCorpusMetadataEditor().putFieldLabel(corpusField, LabelUtils.toLabel(lang, cs));
        }
    }
}

