/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.corpus;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusCommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusHtmlUtils;
import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HtmlPrinter;

public class FieldCreationFormHtmlProducer
extends BdfServerHtmlProducer {
    private final Corpus corpus;

    public FieldCreationFormHtmlProducer(BdfParameters bdfParameters, Corpus corpus) {
        super(bdfParameters);
        this.corpus = corpus;
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addJsLib(BdfJsLibs.SUBSETCHANGE);
        this.addJsLib(BdfJsLibs.CODEMIRRORMODE);
        this.addThemeCss("corpus.css");
    }

    @Override
    public void printHtml() {
        this.start();
        BdfHtmlUtils.printSubsetHeader(this, this.bdfParameters, this.corpus, "field-creationform");
        CorpusHtmlUtils.printCorpusToolbar(this, this.corpus, "field-creationform", this.bdfServer);
        this.printCommandMessageUnit();
        this.DIV("corpus-fields-Grid").DIV("corpus-fields-ListArea").__(PageUnit.start("_ title.corpus.currentstate")).__(this.printCurrentFields()).__(PageUnit.END)._DIV().DIV("corpus-fields-CommandArea");
        CommandBox commandBox = CommandBox.init().action("corpus").family("CRP").veil(true).page("field-creationform");
        CorpusMetadata corpusMetadata = this.corpus.getCorpusMetadata();
        CorpusCommandBoxUtils.printFieldCreationBox(this, commandBox, this.corpus, (short)1);
        CorpusCommandBoxUtils.printFieldCreationBox(this, commandBox, this.corpus, (short)2);
        CorpusCommandBoxUtils.printFieldCreationBox(this, commandBox, this.corpus, (short)3);
        if (!corpusMetadata.isWithSoustitre()) {
            CorpusCommandBoxUtils.printSoustitreActivationBox(this, commandBox, this.corpus);
        }
        this._DIV()._DIV();
        this.end();
    }

    private boolean printCurrentFields() {
        CorpusMetadata currentCorpusMetadata = this.corpus.getCorpusMetadata();
        CorpusField soustitreCorpusField = currentCorpusMetadata.getCorpusField(FieldKey.SOUSTITRE);
        List<CorpusField> proprieteList = currentCorpusMetadata.getProprieteList();
        List<CorpusField> informationList = currentCorpusMetadata.getInformationList();
        List<CorpusField> sectionList = currentCorpusMetadata.getSectionList();
        if (soustitreCorpusField == null && proprieteList.isEmpty() && sectionList.isEmpty() && informationList.isEmpty()) {
            this.P().__localize("_ info.corpus.onlymandatoryfields")._P();
            return true;
        }
        if (soustitreCorpusField != null) {
            this.UL("corpus-fields-List").LI().__(BdfHtmlUtils.printCodeMirrorSpan((HtmlPrinter)this, soustitreCorpusField, this.workingLang)).__(this.printFicheItemType((short)11))._LI()._UL();
        }
        this._UL().UL("corpus-fields-List");
        for (CorpusField corpusField : proprieteList) {
            this.LI().__(BdfHtmlUtils.printCodeMirrorSpan((HtmlPrinter)this, corpusField, this.workingLang)).__(this.printFicheItemType(corpusField.getFicheItemType()))._LI();
        }
        this._UL().UL("corpus-fields-List");
        for (CorpusField corpusField : informationList) {
            this.LI().__(BdfHtmlUtils.printCodeMirrorSpan((HtmlPrinter)this, corpusField, this.workingLang)).__(this.printFicheItemType(corpusField.getFicheItemType()))._LI();
        }
        this._UL().UL("corpus-fields-List");
        for (CorpusField corpusField : sectionList) {
            this.LI().__(BdfHtmlUtils.printCodeMirrorSpan((HtmlPrinter)this, corpusField, this.workingLang))._LI();
        }
        this._UL();
        return true;
    }

    private boolean printFicheItemType(short itemType) {
        this.SPAN("corpus-fields-Type").__localize(CorpusHtmlUtils.getFicheItemMessageKey(itemType))._SPAN();
        return true;
    }
}

