/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.configuration;

import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.conf.BdfServerDirs;
import fr.exemole.bdfserver.email.SmtpManager;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.tools.configuration.PathConfigurationBuilder;
import java.io.File;
import java.util.SortedSet;
import java.util.function.Consumer;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageLog;
import net.mapeadores.util.logging.MessageLogBuilder;

public class EtcConfigHtmlProducer
extends BdfServerHtmlProducer {
    private static final Consumer<HtmlPrinter> MISSING = new Missing();

    public EtcConfigHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.addThemeCss("configuration.css");
    }

    @Override
    public void printHtml() {
        this.start();
        this.__(PageUnit.start("_ title.configuration.paths")).__(this.printPathConfiguration()).__(PageUnit.END);
        this.__(PageUnit.start("_ title.configuration.scripts")).__(this.printExternalScripts()).__(PageUnit.END);
        this.__(PageUnit.start("_ title.configuration.run")).__(this.printRun()).__(PageUnit.END);
        this.__(PageUnit.start("_ title.configuration.smtp")).__(this.printSmtp()).__(PageUnit.END);
        this.end();
    }

    private boolean printPathConfiguration() {
        MessageLogBuilder messageLogBuilder = new MessageLogBuilder();
        PathConfiguration pathConfiguration = PathConfigurationBuilder.build(this.bdfServer, messageLogBuilder);
        BdfServerDirs dirs = this.bdfServer.getBdfServerDirs();
        File pathsIni = dirs.getSubPath("etc.config", "paths.ini");
        File defaultPathsIni = dirs.getSubPath("etc.config.default", "paths.ini");
        this.printPathInfo(pathsIni, "_ label.configuration.path_pathsini", false);
        if (!defaultPathsIni.equals(pathsIni)) {
            this.printPathInfo(defaultPathsIni, "_ label.configuration.path_defaultpathsini", false);
        }
        this.H3().__localize("_ title.configuration.availablepaths")._H3().UL().__(this.printLi("public_path", pathConfiguration.getPublicDirectory().getPath())).__(this.printLi("public_url", pathConfiguration.getPublicUrl("")));
        for (String targetName : pathConfiguration.getTargetNameSet()) {
            this.__(this.printLi("target." + targetName, pathConfiguration.getTargetDirectory(targetName).getPath()));
        }
        this._UL();
        MessageLog messageLog = messageLogBuilder.toMessageLog();
        if (!messageLog.isEmpty()) {
            this.H3().__localize("_ title.configuration.pathlog")._H3().__(LogUtils.printHtml(this, messageLog, "global-Logs"));
        }
        return true;
    }

    private boolean printLi(String name, String value) {
        this.LI().CODE("cm-def").__escape(name)._CODE().__colon().CODE("cm-quote").__escape(value)._CODE()._LI();
        return true;
    }

    private boolean printExternalScripts() {
        this.printPathInfo(this.bdfServer.getBdfServerDirs().getDir("etc.scripts"), "_ label.configuration.path_scripts", true);
        SortedSet<String> nameSet = this.bdfServer.getExternalScriptManager().getScriptNameSet();
        if (nameSet.isEmpty()) {
            this.P("configuration-Info").__localize("_ info.configuration.noscript")._P();
        } else {
            this.H3().__localize("_ title.configuration.availablescripts")._H3().UL();
            for (String name : nameSet) {
                this.LI().A(HA.href(BH.domain("configuration").command("ExternalScriptRunCommand").param("name", name).page("_message")).target("_blank")).__escape(name)._A().__(this.printLogLinks(name))._LI();
            }
            this._UL();
        }
        return true;
    }

    private boolean printRun() {
        this.printPathInfo(this.bdfServer.getBdfServerDirs().getDir("var.run"), "_ label.configuration.path_run", true);
        return true;
    }

    private boolean printSmtp() {
        SmtpManager smtpManager = (SmtpManager)this.bdfServer.getContextObject("smtpManager");
        String iniPath = smtpManager.getIniFilePath();
        if (iniPath.isEmpty()) {
            this.P("configuration-Info").__localize("_ info.configuration.nosmtpparameters")._P();
        } else {
            short iniState = smtpManager.getInitState();
            boolean missing = iniState == -1;
            this.P().__localize("_ label.configuration.path_smtp").__colon().__space().CODE("cm-link").__escape(iniPath)._CODE().__if(missing, MISSING)._P();
            if (iniState == 1) {
                this.P("configuration-Info").__localize("_ info.configuration.smtpok")._P();
            } else if (iniState != -1) {
                this.H3().__localize("_ title.configuration.smtperrorlist")._H3().UL();
                for (String error : smtpManager.getErrorList()) {
                    this.LI().__escape(error)._LI();
                }
                this._UL();
            }
        }
        return true;
    }

    private boolean printLogLinks(String name) {
        boolean withError;
        File resultFile = ConfigurationUtils.getScriptResultLogFile(this.bdfServer, name);
        File errorFile = ConfigurationUtils.getScriptErrorLogFile(this.bdfServer, name);
        boolean withResult = resultFile.exists() && resultFile.length() > 0L;
        boolean bl = withError = errorFile.exists() && errorFile.length() > 0L;
        if (!withResult && !withError) {
            return false;
        }
        this.__space().__escape("(");
        if (withResult) {
            this.A(HA.href(ConfigurationUtils.getLogRelativeUrl("scripts/" + name + ".result.txt")).target("_blank")).__escape("result.txt")._A();
        }
        if (withResult && withError) {
            this.__dash();
        }
        if (withError) {
            this.A(HA.href(ConfigurationUtils.getLogRelativeUrl("scripts/" + name + ".error.txt")).target("_blank")).__escape("error.txt")._A();
        }
        this.__escape(")");
        return true;
    }

    private void printPathInfo(File path, String locKey, boolean isDirectory) {
        boolean missing = false;
        if (!path.exists()) {
            missing = true;
        } else if (isDirectory) {
            if (!path.isDirectory()) {
                missing = true;
            }
        } else if (path.isDirectory()) {
            missing = true;
        }
        this.P().__localize(locKey).__colon().__space().CODE("cm-link").__escape(path.getAbsolutePath())._CODE().__if(missing, MISSING)._P();
    }

    private static class Missing
    implements Consumer<HtmlPrinter> {
        private Missing() {
        }

        @Override
        public void accept(HtmlPrinter hp) {
            hp.__space().SPAN("configuration-Warning").__escape("(").__localize("_ warning.configuration.missingpath").__escape(")")._SPAN();
        }
    }
}

