/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.HtmlPrinterUtils;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.logging.CommandMessage;

public class MessageHtmlProducer
extends BdfServerHtmlProducer {
    private final List<CommandMessage> commandMessageList = new ArrayList<CommandMessage>();

    public MessageHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
    }

    public MessageHtmlProducer(BdfServer bdfServer, LangPreference langPreference) {
        super(bdfServer, langPreference);
    }

    public MessageHtmlProducer addMessages(CommandMessage ... messages) {
        if (messages != null) {
            for (CommandMessage message : messages) {
                this.commandMessageList.add(message);
            }
        }
        return this;
    }

    @Override
    public void printHtml() {
        this.startLoc("_ title.global.message", false);
        this.__(PageUnit.SIMPLE, () -> {
            this.printMainMessage();
            this.printMessageList();
        });
        this.end();
    }

    private boolean printMainMessage() {
        CommandMessage cm = this.getCommandMessage();
        if (cm != null) {
            this.__(HtmlPrinterUtils.printCommandMessage((HtmlPrinter)this, cm, "global-DoneMessage", "global-ErrorMessage"));
            return true;
        }
        return false;
    }

    private boolean printMessageList() {
        if (this.commandMessageList.isEmpty()) {
            return false;
        }
        for (CommandMessage commandMessage : this.commandMessageList) {
            this.__(HtmlPrinterUtils.printCommandMessage((HtmlPrinter)this, commandMessage, "global-DoneMessage", "global-ErrorMessage"));
        }
        return true;
    }

    public static MessageHtmlProducer init(BdfParameters bdfParameters) {
        return new MessageHtmlProducer(bdfParameters);
    }

    public static MessageHtmlProducer init(BdfServer bdfServer, LangPreference langPreference) {
        return new MessageHtmlProducer(bdfServer, langPreference);
    }
}

