/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.streamproducers;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadata;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.opendocument.io.OdSource;
import net.mapeadores.opendocument.io.OdXML;
import net.mapeadores.opendocument.io.OdZip;
import net.mapeadores.opendocument.io.OdZipEngine;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class StatsThesaurusOdsProducer
implements StreamProducer {
    private final String fileName;
    private final Thesaurus thesaurus;
    private final PermissionSummary permissionSummary;
    private final Lang lang;
    private final Predicate<FicheMeta> fichePredicate;

    public StatsThesaurusOdsProducer(String fileName, Thesaurus thesaurus, PermissionSummary permissionSummary, Lang lang, Predicate<FicheMeta> fichePredicate) {
        this.fileName = fileName;
        this.thesaurus = thesaurus;
        this.permissionSummary = permissionSummary;
        this.lang = lang;
        this.fichePredicate = fichePredicate;
    }

    @Override
    public String getMimeType() {
        return "application/vnd.oasis.opendocument.spreadsheet";
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void writeStream(OutputStream outputStream) throws IOException {
        OdZipEngine.run(outputStream, OdZip.spreadSheet().contentOdSource(new ContentOdSource()));
    }

    private class ContentOdSource
    implements OdSource {
        private ContentOdSource() {
        }

        @Override
        public void writeStream(OutputStream outputStream) throws IOException {
            BufferedWriter buf = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
            xmlWriter.appendXMLDeclaration();
            StatsThesaurusXMLPart statsThesaurusXMLPart = new StatsThesaurusXMLPart(xmlWriter, StatsThesaurusOdsProducer.this.thesaurus, StatsThesaurusOdsProducer.this.permissionSummary, StatsThesaurusOdsProducer.this.lang, StatsThesaurusOdsProducer.this.fichePredicate);
            statsThesaurusXMLPart.start();
            statsThesaurusXMLPart.addTable();
            statsThesaurusXMLPart.end();
            buf.flush();
        }
    }

    private static class StatsThesaurusXMLPart
    extends XMLPart {
        private final Thesaurus thesaurus;
        private final Predicate<FicheMeta> fichePredicate;
        private final SubsetKey thesaurusKey;
        private final Corpus[] corpusArray;
        private final boolean withIdalpha;
        private final boolean isBabelien;
        private final Lang thesaurusLang;
        private final MotcleStats motcleStats;

        private StatsThesaurusXMLPart(XMLWriter xmlWriter, Thesaurus thesaurus, PermissionSummary permissionSummary, Lang thesaurusLang, Predicate<FicheMeta> fichePredicate) {
            super(xmlWriter);
            this.thesaurus = thesaurus;
            this.thesaurusKey = thesaurus.getSubsetKey();
            ThesaurusMetadata thesaurusMetaData = thesaurus.getThesaurusMetadata();
            short thesaurusType = thesaurusMetaData.getThesaurusType();
            this.withIdalpha = thesaurusType == 2;
            this.isBabelien = thesaurusType == 3;
            this.thesaurusLang = thesaurusLang;
            this.corpusArray = FichothequeUtils.toCorpusArray(thesaurus.getFichotheque(), permissionSummary.getSubsetAccessPredicate());
            this.motcleStats = new MotcleStats();
            this.fichePredicate = fichePredicate;
        }

        public void start() throws IOException {
            OdXML.openDocumentContent(this);
            OdXML.openBody(this);
            OdXML.openSpreadsheet(this);
        }

        public void end() throws IOException {
            OdXML.closeSpreadsheet(this);
            OdXML.closeBody(this);
            OdXML.closeDocumentContent(this);
        }

        public void addTable() throws IOException {
            String thesaurusName = this.thesaurusKey.getSubsetName();
            OdXML.openTable(this, thesaurusName);
            this.addFirstRow();
            for (Motcle motcle : this.thesaurus.getFirstLevelList()) {
                this.addMotcleRow(motcle);
            }
            OdXML.closeTable(this);
        }

        private void addMotcleRow(Motcle motcle) throws IOException {
            this.motcleStats.updateStats(motcle);
            int total = this.motcleStats.getTotal();
            OdXML.openTableRow(this);
            OdXML.addNumberTableCell((XMLWriter)this, motcle.getId());
            if (this.withIdalpha) {
                OdXML.addStringTableCell(this, motcle.getIdalpha());
            }
            OdXML.addStringTableCell(this, motcle.getLabelString(this.thesaurusLang));
            OdXML.addNumberTableCell((XMLWriter)this, total);
            int[] parCroisement = this.motcleStats.getParCroisement();
            for (int i = 0; i < parCroisement.length; ++i) {
                int ct = parCroisement[i];
                if (ct == 0) {
                    OdXML.addEmptyTableCell(this);
                    continue;
                }
                OdXML.addNumberTableCell((XMLWriter)this, ct);
            }
            OdXML.closeTableRow(this);
            for (Motcle child : motcle.getChildList()) {
                this.addMotcleRow(child);
            }
        }

        private void addFirstRow() throws IOException {
            OdXML.openTableRow(this);
            OdXML.addStringTableCell(this, "id");
            if (this.withIdalpha) {
                OdXML.addStringTableCell(this, "idalpha");
            }
            if (this.isBabelien) {
                OdXML.addStringTableCell(this, "lib");
            } else {
                OdXML.addStringTableCell(this, "lib_" + this.thesaurusLang.toString());
            }
            OdXML.addStringTableCell(this, "_total");
            for (Corpus corpus : this.corpusArray) {
                OdXML.addStringTableCell(this, corpus.getSubsetName());
            }
            OdXML.closeTableRow(this);
        }

        private class MotcleStats {
            private int total = 0;
            private final int[] byCorpus;

            MotcleStats() {
                this.byCorpus = new int[StatsThesaurusXMLPart.this.corpusArray.length];
            }

            void updateStats(Motcle motcle) {
                Fichotheque fichotheque = motcle.getFichotheque();
                this.total = 0;
                int length = StatsThesaurusXMLPart.this.corpusArray.length;
                for (int i = 0; i < length; ++i) {
                    Croisements croisements = fichotheque.getCroisements(motcle, StatsThesaurusXMLPart.this.corpusArray[i]);
                    int ct = 0;
                    if (StatsThesaurusXMLPart.this.fichePredicate != null) {
                        for (Croisements.Entry entry : croisements.getEntryList()) {
                            if (!StatsThesaurusXMLPart.this.fichePredicate.test((FicheMeta)entry.getSubsetItem())) continue;
                            ++ct;
                        }
                    } else {
                        ct = croisements.getEntryList().size();
                    }
                    this.byCorpus[i] = ct;
                    this.total += ct;
                }
            }

            public int getTotal() {
                return this.total;
            }

            public int[] getParCroisement() {
                return this.byCorpus;
            }
        }
    }
}

