/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.streamproducers;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.roles.FichePermission;
import fr.exemole.bdfserver.api.roles.Permission;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.api.subsettree.GroupNode;
import fr.exemole.bdfserver.api.subsettree.SubsetNode;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.roles.RoleUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.opendocument.io.OdSource;
import net.mapeadores.opendocument.io.OdUtils;
import net.mapeadores.opendocument.io.OdZip;
import net.mapeadores.opendocument.io.OdZipEngine;
import net.mapeadores.opendocument.io.SheetNameChecker;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.opendocument.io.odtable.OdTableDefBuilder;
import net.mapeadores.opendocument.io.odtable.OdsOptions;
import net.mapeadores.opendocument.io.odtable.OdsXMLPart;
import net.mapeadores.opendocument.io.odtable.StyleManager;
import net.mapeadores.opendocument.io.odtable.StyleManagerBuilder;
import net.mapeadores.opendocument.io.odtable.TableSettings;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.io.TempStorageAppendable;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class RoleOdsProducer
implements StreamProducer {
    private final String fileName;
    private final BdfServer bdfServer;
    private final BdfUser bdfUser;
    private final Role[] roleArray;
    private final MessageLocalisation messageLocalisation;
    private final SheetNameChecker sheetNameChecker;
    private final int defaultRoleIndex;

    public RoleOdsProducer(BdfServer bdfServer, BdfUser bdfUser, Role role, String fileName) {
        this.fileName = fileName;
        this.bdfServer = bdfServer;
        this.bdfUser = bdfUser;
        if (role != null) {
            this.roleArray = new Role[1];
            this.roleArray[0] = role;
        } else {
            List<Role> roleList = bdfServer.getPermissionManager().getRoleList();
            this.roleArray = roleList.toArray(new Role[roleList.size()]);
        }
        this.defaultRoleIndex = RoleOdsProducer.getDefaultRoleIndex(this.roleArray);
        this.messageLocalisation = bdfServer.getL10nManager().getMessageLocalisation(bdfUser);
        this.sheetNameChecker = new SheetNameChecker();
    }

    @Override
    public String getMimeType() {
        return "application/vnd.oasis.opendocument.spreadsheet";
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void writeStream(OutputStream outputStream) throws IOException {
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        this.addTableInfo((short)1, list);
        this.addTableInfo((short)2, list);
        this.addTableInfo((short)3, list);
        this.addTableInfo((short)5, list);
        this.addTableInfo((short)4, list);
        OdsOptions odsOptions = BdfServerUtils.buildOdsOptions(this.bdfServer, "bdf://this/css/ods/role.css");
        OdZipEngine.run(outputStream, OdZip.spreadSheet().stylesOdSource(OdUtils.toStyleOdSource(odsOptions.elementMaps(), true)).contentOdSource(new ContentOdSource(odsOptions, list)).settingsOdSource(this.getSettingsOdSource(list)));
    }

    private void addTableInfo(short subsetCategory, List<TableInfo> list) {
        String tableName = this.messageLocalisation.toString(BdfHtmlUtils.getSubsetCollectionLocKey(subsetCategory));
        if (tableName == null) {
            tableName = SubsetKey.categoryToString(subsetCategory);
        }
        tableName = this.sheetNameChecker.checkName(tableName);
        OdTableDef odTableDef = this.getTableDef(tableName, subsetCategory);
        ArrayList<PermissionBySubset> permissionBySubsetList = new ArrayList<PermissionBySubset>();
        this.checkPermission(permissionBySubsetList, this.bdfServer.getTreeManager().getSubsetTree(subsetCategory).getNodeList());
        if (!permissionBySubsetList.isEmpty()) {
            list.add(new TableInfo(subsetCategory, odTableDef, permissionBySubsetList));
        }
    }

    private OdTableDef getTableDef(String tableName, short subsetCategory) {
        return OdTableDefBuilder.init(tableName).addStandard("Subsets", "SubsetTitle").addStandards(this.roleArray.length, "Role").toOdTableDef();
    }

    private void checkPermission(List<PermissionBySubset> permissionBySubsetList, List<SubsetTree.Node> nodeList) {
        int roleCount = this.roleArray.length;
        for (SubsetTree.Node node : nodeList) {
            if (node instanceof SubsetNode) {
                SubsetKey subsetKey = ((SubsetNode)node).getSubsetKey();
                Subset subset = this.bdfServer.getFichotheque().getSubset(subsetKey);
                if (subset == null) continue;
                PermissionBySubset permissionBySubset = new PermissionBySubset(subset, roleCount);
                for (int j = 0; j < roleCount; ++j) {
                    Permission permission = this.roleArray[j].getPermissionBySubsetKey(subsetKey);
                    if (permission == null) continue;
                    permissionBySubset.setPermission(j, permission);
                }
                permissionBySubsetList.add(permissionBySubset);
                continue;
            }
            if (!(node instanceof GroupNode)) continue;
            this.checkPermission(permissionBySubsetList, ((GroupNode)node).getSubnodeList());
        }
    }

    private OdSource getSettingsOdSource(List<TableInfo> tableInfoList) {
        ArrayList<TableSettings> settingsList = new ArrayList<TableSettings>();
        for (TableInfo tableInfo : tableInfoList) {
            settingsList.add(TableSettings.init(tableInfo.odTableDef.getTableName()).fixedRows(1).fixedColumns(1));
        }
        return OdUtils.getSettingsOdSource(settingsList);
    }

    private static int getDefaultRoleIndex(Role[] roleArray) {
        int length = roleArray.length;
        for (int i = 0; i < length; ++i) {
            if (!RoleUtils.isDefaultRole(roleArray[i])) continue;
            return i;
        }
        return -1;
    }

    private class ContentOdSource
    implements OdSource {
        private final OdsOptions odsOptions;
        private final List<TableInfo> tableInfoList;

        private ContentOdSource(OdsOptions odsOptions, List<TableInfo> tableInfoList) {
            this.odsOptions = odsOptions;
            this.tableInfoList = tableInfoList;
        }

        @Override
        public void writeStream(OutputStream outputStream) throws IOException {
            StyleManager styleManager = this.initStyleManager();
            TempStorageAppendable bodyBuffer = new TempStorageAppendable();
            ContentXMLPart xmlPart = new ContentXMLPart(XMLUtils.toXMLWriter(bodyBuffer, 3), styleManager);
            for (TableInfo tableInfo : this.tableInfoList) {
                xmlPart.addTable(tableInfo);
            }
            xmlPart.insertErrorLogTable(this.odsOptions.odLog(), RoleOdsProducer.this.sheetNameChecker.checkName("css log"));
            OdUtils.writeSpreadSheetDocumentContent(outputStream, bodyBuffer, styleManager);
        }

        private StyleManager initStyleManager() {
            StyleManagerBuilder styleManagerBuilder = new StyleManagerBuilder();
            styleManagerBuilder.setElementMaps(this.odsOptions.elementMaps());
            for (TableInfo tableInfo : this.tableInfoList) {
                styleManagerBuilder.addTableDef(tableInfo.odTableDef);
            }
            return styleManagerBuilder.toStyleManager();
        }
    }

    private static class TableInfo {
        private final short subsetCategory;
        private final OdTableDef odTableDef;
        private final List<PermissionBySubset> permissionBySubsetList;

        private TableInfo(short subsetCategory, OdTableDef odTableDef, List<PermissionBySubset> permissionBySubsetList) {
            this.subsetCategory = subsetCategory;
            this.odTableDef = odTableDef;
            this.permissionBySubsetList = permissionBySubsetList;
        }
    }

    private static class PermissionBySubset {
        private final Subset subset;
        private final Permission[] permissionArray;

        private PermissionBySubset(Subset subset, int count) {
            this.subset = subset;
            this.permissionArray = new Permission[count];
        }

        public Subset getSubset() {
            return this.subset;
        }

        public void setPermission(int i, Permission permission) {
            this.permissionArray[i] = permission;
        }

        public Permission getPermission(int i) {
            return this.permissionArray[i];
        }
    }

    private class ContentXMLPart
    extends OdsXMLPart {
        private final Lang workingLang;

        private ContentXMLPart(XMLWriter xmlWriter, StyleManager styleManager) {
            super(xmlWriter, styleManager);
            this.workingLang = RoleOdsProducer.this.bdfUser.getWorkingLang();
        }

        public void addTable(TableInfo tableInfo) throws IOException {
            int roleCount = RoleOdsProducer.this.roleArray.length;
            this.tableStart(tableInfo.odTableDef.getTableName());
            this.rowStart();
            this.emptyCell();
            for (int i = 0; i < roleCount; ++i) {
                Role role = RoleOdsProducer.this.roleArray[i];
                StringBuilder buf = new StringBuilder();
                String name = role.getName();
                if (RoleUtils.isDefaultRole(role)) {
                    buf.append(RoleOdsProducer.this.messageLocalisation.toString("_ label.global.role_default"));
                } else {
                    buf.append('[');
                    buf.append(name);
                    buf.append(']');
                }
                String roleTitle = role.getTitleLabels().seekLabelString(this.workingLang, null);
                if (roleTitle != null) {
                    buf.append(" ");
                    buf.append(roleTitle);
                }
                this.stringCell(buf.toString(), "RoleTitle");
            }
            this.rowEnd();
            for (PermissionBySubset couple : tableInfo.permissionBySubsetList) {
                Subset subset = couple.getSubset();
                StringBuilder buf = new StringBuilder();
                buf.append(FichothequeUtils.getTitle(subset, this.workingLang));
                buf.append(" [");
                buf.append(subset.getSubsetName());
                buf.append("]");
                this.rowStart();
                this.stringCell(buf.toString());
                for (int j = 0; j < roleCount; ++j) {
                    boolean defaultRole = j == RoleOdsProducer.this.defaultRoleIndex;
                    this.addPermission(couple.getPermission(j), defaultRole);
                }
                this.rowEnd();
            }
            this.tableEnd();
        }

        private void addPermission(Permission permission, boolean defaultRole) throws IOException {
            if (permission == null) {
                if (defaultRole) {
                    this.stringCell("S", "Standard");
                } else {
                    this.stringCell("", "Status");
                }
            } else {
                switch (permission.getLevel()) {
                    case 3: {
                        this.stringCell("A", "Admin");
                        break;
                    }
                    case 2: {
                        String value = this.getCustomPermissionValue(permission.getCustomPermission());
                        this.stringCell(value, "Custom");
                        break;
                    }
                    case 1: {
                        this.stringCell("S", "Standard");
                        break;
                    }
                    case 0: {
                        this.stringCell("N", "None");
                        break;
                    }
                    default: {
                        this.stringCell("", "Status");
                    }
                }
            }
        }

        private String getCustomPermissionValue(Permission.CustomPermission customPermission) {
            if (customPermission instanceof FichePermission) {
                return this.getFichePermissionValue((FichePermission)customPermission);
            }
            return "?";
        }

        private String getFichePermissionValue(FichePermission fichePermission) {
            StringBuilder buf = new StringBuilder();
            buf.append("R=");
            buf.append(RoleUtils.fichePermissionTypeToString(fichePermission.read()));
            short write = fichePermission.write();
            if (write != 0) {
                buf.append(" W=");
                buf.append(RoleUtils.fichePermissionTypeToString(write));
            }
            if (fichePermission.create()) {
                buf.append(" C");
            }
            return buf.toString();
        }
    }
}

