/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.instructions;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.docstream.VersionDocStream;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.roles.PermissionSummaryBuilder;
import java.text.ParseException;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.addenda.Version;
import net.fichotheque.permission.PermissionSummary;
import net.mapeadores.util.mimetype.MimeTypeResolver;
import net.mapeadores.util.mimetype.MimeTypeUtils;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.exceptions.ForbiddenException;
import net.mapeadores.util.servlets.handlers.DocStreamResponseHandler;

public class DocumentsInstruction
implements BdfInstruction {
    private final BdfServer bdfServer;
    private final Version version;

    private DocumentsInstruction(BdfServer bdfServer, Version version) {
        this.bdfServer = bdfServer;
        this.version = version;
    }

    @Override
    public short getBdfUserNeed() {
        return 3;
    }

    @Override
    public ResponseHandler runInstruction(BdfUser bdfUser) {
        Addenda addenda;
        PermissionSummary permissionSummary = PermissionSummaryBuilder.build(this.bdfServer, bdfUser);
        if (!permissionSummary.hasAccess(addenda = this.version.getDocument().getAddenda())) {
            throw new ForbiddenException();
        }
        MimeTypeResolver mimeTypeResolver = this.bdfServer.getMimeTypeResolver();
        String mimeType = MimeTypeUtils.getMimeType(mimeTypeResolver, this.version.getFileName());
        String charset = MimeTypeUtils.getDefaultCharset(mimeType);
        return new DocStreamResponseHandler(new VersionDocStream(this.version, mimeType, charset));
    }

    public static BdfInstruction build(BdfServer bdfServer, String filePath) {
        int idx1 = filePath.indexOf(47);
        BdfInstruction bdfInstruction = idx1 == -1 ? DocumentsInstruction.buildFromId(bdfServer, filePath) : DocumentsInstruction.buildFromName(bdfServer, filePath.substring(0, idx1), filePath.substring(idx1 + 1));
        if (bdfInstruction == null) {
            bdfInstruction = BdfInstructionUtils.NOTFOUND_BDFINSTRUCTION;
        }
        return bdfInstruction;
    }

    private static BdfInstruction buildFromName(BdfServer bdfServer, String addendaName, String documentName) {
        SubsetKey addendaKey;
        try {
            addendaKey = SubsetKey.parse((short)4, addendaName);
        }
        catch (ParseException pe) {
            return null;
        }
        int idx3 = documentName.lastIndexOf(46);
        if (idx3 == -1) {
            return null;
        }
        String basename = documentName.substring(0, idx3);
        String extension = documentName.substring(idx3 + 1);
        Addenda addenda = (Addenda)bdfServer.getFichotheque().getSubset(addendaKey);
        if (addenda == null) {
            return null;
        }
        Document document = addenda.getDocumentByBasename(basename);
        if (document == null) {
            return null;
        }
        Version version = document.getVersionByExtension(extension);
        if (version == null) {
            return null;
        }
        return new DocumentsInstruction(bdfServer, version);
    }

    private static BdfInstruction buildFromId(BdfServer bdfServer, String documentName) {
        int documentid;
        SubsetKey addendaKey;
        int idx2 = documentName.indexOf(45);
        if (idx2 == -1) {
            return null;
        }
        int idx3 = documentName.indexOf(46);
        if (idx3 == -1) {
            return null;
        }
        if (idx3 < idx2) {
            return null;
        }
        try {
            addendaKey = SubsetKey.parse((short)4, documentName.substring(0, idx2));
        }
        catch (ParseException pe) {
            return null;
        }
        try {
            documentid = Integer.parseInt(documentName.substring(idx2 + 1, idx3));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        String extension = documentName.substring(idx3 + 1);
        Addenda addenda = (Addenda)bdfServer.getFichotheque().getSubset(addendaKey);
        if (addenda == null) {
            return null;
        }
        Document document = addenda.getDocumentById(documentid);
        if (document == null) {
            return null;
        }
        Version version = document.getVersionByExtension(extension);
        if (version == null) {
            return null;
        }
        return new DocumentsInstruction(bdfServer, version);
    }
}

