/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.access.v1;

import fr.exemole.bdfserver.get.access.AccessGate;
import fr.exemole.bdfserver.tools.instruction.AbstractUtilRequestHandler;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Predicate;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.corpus.FichesBuilder;
import net.fichotheque.tools.selection.SelectionEngines;
import net.fichotheque.utils.selection.FicheSelectorBuilder;
import net.fichotheque.utils.selection.MotcleSelectorBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class AccessGateRequestHandler
extends AbstractUtilRequestHandler {
    private final AccessGate accessGate;

    public AccessGateRequestHandler(AccessGate accessGate, RequestMap requestMap) {
        super(accessGate.getBdfServer(), requestMap);
        this.accessGate = accessGate;
    }

    public AccessGate getAccessGate() {
        return this.accessGate;
    }

    @Override
    protected void store(String paramName, String paramValue) {
    }

    public Comparator<FicheMeta> getComparator() throws ErrorMessageException {
        return this.getComparator(this.accessGate.getLang());
    }

    public FicheMeta getFiche() throws ErrorMessageException {
        FicheMeta ficheMeta = this.getMandatoryFicheMeta();
        if (!this.accessGate.getFichePredicate().test(ficheMeta)) {
            throw BdfErrors.unknownParameterValue("id", String.valueOf(ficheMeta.getId()));
        }
        return ficheMeta;
    }

    public Motcle getMotcle() throws ErrorMessageException {
        Motcle motcle = this.getMandatoryMotcle();
        if (!this.accessGate.getMotclePredicate().test(motcle)) {
            throw BdfErrors.unknownParameterValue("id", String.valueOf(motcle.getId()));
        }
        return motcle;
    }

    public Fiches getFiches() throws ErrorMessageException {
        SelectionContext selectionContext = this.accessGate.getSelectionContext();
        String selection = this.requestMap.getParameter("selection");
        String xml = this.requestMap.getParameter("xml");
        FichesBuilder fichesBuilder = FichesBuilder.init(this.getComparator()).initSubsetKeyOrder(TreeUtils.getCorpusKeyList(this.bdfServer));
        if (selection != null || xml != null) {
            FicheSelectorBuilder selectorBuilder = FicheSelectorBuilder.init(selectionContext);
            if (selection != null) {
                this.populateFromSelection(selectorBuilder);
            } else {
                this.populateFromXml(selectorBuilder);
            }
            fichesBuilder.populate(selectorBuilder.toFicheSelector());
        } else {
            Predicate<FicheMeta> fichePredicate = this.accessGate.getFichePredicate();
            for (Corpus corpus : this.bdfServer.getFichotheque().getCorpusList()) {
                if (!this.accessGate.getSubsetPredicate().test(corpus)) continue;
                for (FicheMeta ficheMeta : corpus.getFicheMetaList()) {
                    if (!fichePredicate.test(ficheMeta)) continue;
                    fichesBuilder.add(ficheMeta);
                }
            }
        }
        return fichesBuilder.toFiches();
    }

    public Thesaurus getThesaurus() throws ErrorMessageException {
        Thesaurus thesaurus = this.getMandatoryThesaurus();
        if (!this.accessGate.getSubsetPredicate().test(thesaurus)) {
            throw BdfErrors.unknownParameterValue("thesaurus", thesaurus.getSubsetName());
        }
        return thesaurus;
    }

    public Collection<FicheMeta> getFicheArray() throws ErrorMessageException {
        SelectionContext selectionContext = this.accessGate.getSelectionContext();
        Comparator<FicheMeta> comparator = this.getComparator();
        FicheSelectorBuilder selectorBuilder = FicheSelectorBuilder.init(selectionContext);
        this.populateFromXml(selectorBuilder);
        return SelectionEngines.run(selectionContext, selectorBuilder.toFicheSelector(), comparator);
    }

    public Collection<Motcle> getMotcleArray() throws ErrorMessageException {
        SelectionContext selectionContext = this.accessGate.getSelectionContext();
        MotcleSelectorBuilder selectorBuilder = MotcleSelectorBuilder.init(selectionContext);
        this.populateFromXml(selectorBuilder);
        return SelectionEngines.run(selectionContext, null, selectorBuilder.toMotcleSelector(), null);
    }

    public static AccessGateRequestHandler init(AccessGate accessGate, RequestMap requestMap) {
        return new AccessGateRequestHandler(accessGate, requestMap);
    }
}

