/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.policies.PolicyUtils;
import java.util.ArrayList;
import net.fichotheque.SubsetKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.policies.DynamicEditPolicy;
import net.fichotheque.tools.externalsource.ExternalSourceDefBuilder;
import net.fichotheque.tools.thesaurus.DynamicEditPolicyBuilder;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ThesaurusPolicyCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ThesaurusPolicy";
    public static final String COMMANDKEY = "_ THS-05";
    public static final String LANGLIST_PARAMNAME = "langlist";
    public static final String POLICY_PARAMNAME = "policy";
    public static final String TRANSFERKEY_PARAMNAME = "transferkey";
    public static final String CHECKKEYLIST_PARAMNAME = "checkkeylist";
    public static final String EXTERNALTYPE_PARAMNAME = "externaltype";
    public static final String EXTERNAL_PARAMPREFIX = "external_";
    public static final String POLICY_NONE_PARAMVALUE = "none";
    public static final String POLICY_ALLOW_PARAMVALUE = "allow";
    public static final String POLICY_CHECK_PARAMVALUE = "check";
    public static final String POLICY_TRANSFER_PARAMVALUE = "transfer";
    public static final String POLICY_EXTERNAL_PARAMVALUE = "external";
    private Thesaurus thesaurus;
    private DynamicEditPolicy newPolicy;

    public ThesaurusPolicyCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            session.getBdfServerEditor().setSubsetPolicy(this.thesaurus.getSubsetKey(), this.newPolicy);
        }
        this.setDone("_ done.thesaurus.thesauruspolicy", new Object[0]);
        this.putResultObject("obj.thesaurus", this.thesaurus);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        String policyParam;
        this.checkFichothequeAdmin();
        this.thesaurus = this.requestHandler.getMandatoryThesaurus();
        switch (policyParam = this.getMandatory(POLICY_PARAMNAME)) {
            case "none": {
                this.newPolicy = ThesaurusUtils.NONE_POLICY;
                break;
            }
            case "allow": {
                this.newPolicy = ThesaurusUtils.ALLOW_POLICY;
                break;
            }
            case "transfer": {
                this.newPolicy = this.getTransferPolicy();
                break;
            }
            case "check": {
                this.newPolicy = this.getCheckPolicy();
                break;
            }
            case "external": {
                this.newPolicy = this.getExternalPolicy();
                break;
            }
            default: {
                throw BdfErrors.unknownParameterValue(POLICY_PARAMNAME, policyParam);
            }
        }
        if (!PolicyUtils.isValid(this.thesaurus, this.newPolicy)) {
            throw BdfErrors.unsupportedParameterValue(POLICY_PARAMNAME, policyParam);
        }
    }

    private DynamicEditPolicy getTransferPolicy() throws ErrorMessageException {
        String transferKeyParam = this.getMandatory(TRANSFERKEY_PARAMNAME);
        Thesaurus transferThesaurus = FichothequeUtils.getThesaurus(this.bdfServer.getFichotheque(), transferKeyParam);
        if (transferThesaurus == null || !transferThesaurus.isBabelienType()) {
            throw BdfErrors.unknownParameterValue(TRANSFERKEY_PARAMNAME, transferKeyParam);
        }
        return DynamicEditPolicyBuilder.buildTransfer(transferThesaurus.getSubsetKey());
    }

    private DynamicEditPolicy getCheckPolicy() throws ErrorMessageException {
        String[] array = this.requestHandler.getTokens(CHECKKEYLIST_PARAMNAME);
        if (array.length == 0) {
            throw BdfErrors.emptyMandatoryParameter(CHECKKEYLIST_PARAMNAME);
        }
        ArrayList<SubsetKey> list = new ArrayList<SubsetKey>();
        for (String thesaurusName : array) {
            Thesaurus verifThesaurus = FichothequeUtils.getThesaurus(this.fichotheque, thesaurusName);
            if (verifThesaurus == null || verifThesaurus.isIdalphaType()) continue;
            list.add(verifThesaurus.getSubsetKey());
        }
        if (list.isEmpty()) {
            throw BdfErrors.wrongParameterValue(CHECKKEYLIST_PARAMNAME, ((Object)list).toString());
        }
        return DynamicEditPolicyBuilder.buildCheck(list);
    }

    private DynamicEditPolicy getExternalPolicy() throws ErrorMessageException {
        String externalType = this.requestHandler.getTrimedParameter(EXTERNALTYPE_PARAMNAME);
        if (externalType.isEmpty()) {
            return ThesaurusUtils.NONE_POLICY;
        }
        ExternalSourceDefBuilder externalSourceDefBuilder = new ExternalSourceDefBuilder(externalType);
        String prefix = EXTERNAL_PARAMPREFIX + externalType + "|";
        for (String paramName : this.requestHandler.getParameterNameSet()) {
            if (!paramName.startsWith(prefix)) continue;
            externalSourceDefBuilder.addParam(paramName.substring(prefix.length()), this.requestHandler.getMandatoryParameter(paramName));
        }
        return DynamicEditPolicyBuilder.buildExternal(externalSourceDefBuilder.toExternalSourceDef());
    }
}

