/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.tools.croisement.CroisementChangeEngine;
import net.fichotheque.tools.croisement.LienBuffer;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class MotclePonderationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "MotclePonderation";
    public static final String COMMANDKEY = "_ THS-14";
    private Motcle motcle;
    private final Map<String, PonderationByCorpus> ponderationByCorpusMap = new HashMap<String, PonderationByCorpus>();

    public MotclePonderationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            CroisementEditor croisementsEditor = session.getFichothequeEditor().getCroisementEditor();
            CroisementChangeEngine croisementChangeEngine = CroisementChangeEngine.appendOrPoidsReplaceEngine(this.motcle);
            for (PonderationByCorpus ponderationByCorpus : this.ponderationByCorpusMap.values()) {
                List bufferList = ponderationByCorpus.getLienBufferList();
                int size = bufferList.size();
                for (int i = 0; i < size; ++i) {
                    croisementChangeEngine.addLien((LienBuffer)bufferList.get(i));
                }
            }
            croisementsEditor.updateCroisements(this.motcle, croisementChangeEngine.toCroisementChanges());
        }
        this.putResultObject("obj.thesaurus", this.motcle.getThesaurus());
        this.putResultObject("obj.motcle", this.motcle);
        this.setDone("_ done.thesaurus.motcleponderation", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.motcle = this.requestHandler.getMandatoryMotcle();
        this.checkSubsetAdmin(this.motcle.getThesaurus());
        HashSet<String> wrongCorpusSet = new HashSet<String>();
        String mode = "";
        for (String paramName : this.requestHandler.getParameterNameSet()) {
            int idx = paramName.indexOf(95);
            if (idx == -1) continue;
            try {
                String corpusName;
                int id = Integer.parseInt(paramName.substring(idx + 1));
                String poidsString = this.requestHandler.getTrimedParameter(paramName);
                int poids = 1;
                if (!poidsString.isEmpty()) {
                    poids = Integer.parseInt(poidsString);
                }
                if (poids < 1 || wrongCorpusSet.contains(corpusName = paramName.substring(0, idx))) continue;
                PonderationByCorpus ponderationByCorpus = this.ponderationByCorpusMap.get(corpusName);
                if (ponderationByCorpus == null) {
                    Corpus corpus = FichothequeUtils.getCorpus(this.fichotheque, corpusName);
                    if (corpus == null || !this.getPermissionSummary().hasAccess(corpus)) {
                        wrongCorpusSet.add(corpusName);
                        continue;
                    }
                    ponderationByCorpus = new PonderationByCorpus(corpus);
                    this.ponderationByCorpusMap.put(corpusName, ponderationByCorpus);
                }
                ponderationByCorpus.add(id, mode, poids);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private static class PonderationByCorpus {
        private final Corpus corpus;
        private final List<LienBuffer> lienBufferList = new ArrayList<LienBuffer>();

        private PonderationByCorpus(Corpus corpus) {
            this.corpus = corpus;
        }

        private void add(int id, String mode, int poids) {
            FicheMeta ficheMeta = this.corpus.getFicheMetaById(id);
            if (ficheMeta != null) {
                this.lienBufferList.add(new LienBuffer(ficheMeta, mode, poids));
            }
        }

        private List<LienBuffer> getLienBufferList() {
            return this.lienBufferList;
        }

        private Corpus getCorpus() {
            return this.corpus;
        }
    }
}

