/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.commands.AbstractPhrasesCommand;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.sphere.metadata.SphereMetadataEditor;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class SpherePhrasesCommand
extends AbstractPhrasesCommand {
    public static final String COMMANDNAME = "SpherePhrases";
    public static final String COMMANDKEY = "_ SPH-02";
    private Sphere sphere;

    public SpherePhrasesCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        boolean done = false;
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            SphereMetadataEditor sphereMetadataEditor = session.getFichothequeEditor().getSphereEditor(this.sphere.getSubsetKey()).getSphereMetadataEditor();
            if (this.update(sphereMetadataEditor)) {
                done = true;
            }
        }
        this.putResultObject("obj.sphere", this.sphere);
        if (done) {
            this.setDone("_ done.sphere.spherephrases", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.sphere = this.requestHandler.getMandatorySphere();
        this.checkSubsetAdmin(this.sphere);
        this.checkPhrasesParameters();
    }
}

