/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.importation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfCommand;
import fr.exemole.bdfserver.commands.importation.CorpusImportParseCommand;
import fr.exemole.bdfserver.commands.importation.HtmlConversionCommand;
import fr.exemole.bdfserver.commands.importation.ImportationEngineCommand;
import fr.exemole.bdfserver.commands.importation.LabelImportParseCommand;
import fr.exemole.bdfserver.commands.importation.MetaReportCommand;
import fr.exemole.bdfserver.commands.importation.ThesaurusImportParseCommand;
import net.mapeadores.util.request.RequestMap;

public class ImportationCommandFactory {
    private ImportationCommandFactory() {
    }

    public static BdfCommand getBdfCommand(BdfServer bdfServer, RequestMap requestMap, String commandName) {
        switch (commandName) {
            case "LabelImportParse": {
                return new LabelImportParseCommand(bdfServer, requestMap);
            }
            case "ThesaurusImportParse": {
                return new ThesaurusImportParseCommand(bdfServer, requestMap);
            }
            case "CorpusImportParse": {
                return new CorpusImportParseCommand(bdfServer, requestMap);
            }
            case "ImportationEngine": {
                return new ImportationEngineCommand(bdfServer, requestMap);
            }
            case "HtmlConversion": {
                return new HtmlConversionCommand(bdfServer, requestMap);
            }
            case "MetaReport": {
                return new MetaReportCommand(bdfServer, requestMap);
            }
        }
        return null;
    }
}

