/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.storage.TemplateStorage;
import fr.exemole.bdfserver.tools.configuration.PathConfigurationBuilder;
import fr.exemole.bdfserver.tools.exportation.transformation.BdfTransformationUtils;
import fr.exemole.bdfserver.tools.exportation.transformation.TransformationAvailabilities;
import fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates.DefaultOptions;
import fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates.TemplateStorageUnitFactory;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import java.text.ParseException;
import java.util.LinkedHashSet;
import net.fichotheque.EditOrigin;
import net.fichotheque.SubsetKey;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationDescription;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.namespaces.TransformationSpace;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.attr.AttributesBuilder;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.ValidExtension;

public class TemplateCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TemplateCreation";
    public static final String COMMANDKEY = "_ EXP-31";
    public static final String NEW_TEMPLATE_PARAMNAME = "newtemplate";
    public static final String NOEMPTYCOMPONENTS_PARAMNAME = "noemptycomponents";
    public static final String TYPE_PARAMNAME = "type";
    public static final String HTML_XSLT_TYPE_PARAMVALUE = "html_xslt";
    public static final String FRAGMENT_XSLT_TYPE_PARAMVALUE = "fragment_xslt";
    public static final String ODT_XSLT_TYPE_PARAMVALUE = "odt_xslt";
    public static final String ODT_PROPERTIES_TYPE_PARAMVALUE = "odt_properties";
    public static final String WITHEXTRACTION_PARAMNAME = "withextraction";
    public static final String COMPACTSTYLE_PARAMNAME = "compactstyle";
    public static final String TABLEXPORT_PARAMNAME = "tableexportname";
    public static final String CORPUSLIST_PARAMNAME = "corpuslist";
    private TemplateKey templateKey;
    private String creationType;
    private String templateType;
    private String tableExportName;
    private DefaultOptions options;
    private Attributes initAttributes;

    public TemplateCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        TemplateStorage.Unit defaultTemplateStorageUnit = this.getDefaultTemplateStorageUnit();
        try {
            TemplateDescription templateDescription = this.bdfServer.getTransformationManager().createTemplate(defaultTemplateStorageUnit, editOrigin);
            this.putResultObject("obj.templatedescription", templateDescription);
            this.setDone("_ done.exportation.templatecreation", this.templateKey.getKeyString());
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        TransformationDescription transformationDescription = this.requestHandler.getMandatoryTransformationDescription();
        TransformationKey transformationKey = transformationDescription.getTransformationKey();
        String templateName = this.getMandatory(NEW_TEMPLATE_PARAMNAME);
        templateName = templateName.trim();
        if (templateName.length() == 0) {
            throw BdfErrors.error("_ error.empty.templatename", templateName);
        }
        if (!StringUtils.isTechnicalName(templateName, true)) {
            throw BdfErrors.error("_ error.wrong.templatename", templateName);
        }
        this.options = DefaultOptions.init().withExtractionDef(this.requestHandler.isTrue(WITHEXTRACTION_PARAMNAME)).compactStyle(this.requestHandler.isTrue(COMPACTSTYLE_PARAMNAME));
        this.creationType = this.getMandatory(TYPE_PARAMNAME);
        ValidExtension validExtension = TemplateCreationCommand.getValidExtension(this.creationType);
        this.templateType = TemplateCreationCommand.getTemplateType(this.creationType);
        this.tableExportName = this.requestHandler.getTrimedParameter(TABLEXPORT_PARAMNAME);
        try {
            this.templateKey = TemplateKey.parse(transformationKey, validExtension, templateName);
        }
        catch (ParseException pe) {
            throw new ShouldNotOccurException("Test done before");
        }
        if (this.bdfServer.getTransformationManager().containsTemplate(this.templateKey)) {
            throw BdfErrors.error("_ error.existing.template", templateName);
        }
        if (transformationKey.isCorpusTransformationKey() && !this.fichotheque.containsSubset(transformationKey.toCorpusKey())) {
            throw BdfErrors.unknownParameterValue("transformation", transformationKey.toCorpusKey().getKeyString());
        }
        if (!TransformationAvailabilities.isValidTemplateType(this.templateType, this.templateKey)) {
            throw BdfErrors.error("_ error.unknown.transformation.templatetype", this.creationType);
        }
        TemplateCreationCommand.testDefaultTemplateAvailable(this.creationType, transformationKey);
        this.initAttributes = this.initAttributes(transformationKey);
    }

    private Attributes initAttributes(TransformationKey transformationKey) throws ErrorMessageException {
        String[] corpusNameArray;
        AttributesBuilder attributesBuilder;
        if (!this.creationType.equals(ODT_PROPERTIES_TYPE_PARAMVALUE)) {
            attributesBuilder = new AttributesBuilder(BdfTransformationUtils.XSLT_DEFAULT_TEMPLATE_ATTRIBUTES);
            if (TransformationAvailabilities.hasDefaultExtractionDef(transformationKey)) {
                String emptyComponents = this.requestHandler.isTrue(NOEMPTYCOMPONENTS_PARAMNAME) ? "false" : "true";
                attributesBuilder.appendValue(TransformationSpace.EMPTYCOMPONENTS_KEY, emptyComponents);
            }
            if (this.creationType.equals(ODT_XSLT_TYPE_PARAMVALUE)) {
                BdfTransformationUtils.checkOdtTransformerAttributes(attributesBuilder, this.bdfServer, transformationKey);
            }
        } else {
            attributesBuilder = new AttributesBuilder();
        }
        if (TransformationAvailabilities.useCorpusListAttribute(transformationKey) && (corpusNameArray = this.requestHandler.getTokens(CORPUSLIST_PARAMNAME)).length > 0) {
            LinkedHashSet<SubsetKey> set = new LinkedHashSet<SubsetKey>();
            for (String corpusName : corpusNameArray) {
                try {
                    SubsetKey corpusKey = SubsetKey.parse((short)1, corpusName);
                    if (!this.fichotheque.containsSubset(corpusKey)) continue;
                    set.add(corpusKey);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (!set.isEmpty()) {
                for (SubsetKey corpusKey : set) {
                    attributesBuilder.appendValue(TransformationSpace.CORPUS_KEY, corpusKey.getSubsetName());
                }
            }
        }
        return attributesBuilder.toAttributes();
    }

    private static ValidExtension getValidExtension(String creationType) throws ErrorMessageException {
        switch (creationType) {
            case "html_xslt": 
            case "fragment_xslt": {
                return null;
            }
            case "odt_xslt": 
            case "odt_properties": {
                return ValidExtension.ODT;
            }
        }
        throw BdfErrors.wrongParameterValue(TYPE_PARAMNAME, creationType);
    }

    private static String getTemplateType(String creationType) throws ErrorMessageException {
        switch (creationType) {
            case "html_xslt": 
            case "fragment_xslt": 
            case "odt_xslt": {
                return "xslt";
            }
            case "odt_properties": {
                return "properties";
            }
        }
        throw BdfErrors.wrongParameterValue(TYPE_PARAMNAME, creationType);
    }

    private static void testDefaultTemplateAvailable(String creationType, TransformationKey transformationKey) throws ErrorMessageException {
        switch (creationType) {
            case "fragment_xslt": {
                if (TransformationAvailabilities.hasDefaultFragment(transformationKey)) break;
                throw BdfErrors.wrongParameterValue(TYPE_PARAMNAME, creationType);
            }
        }
    }

    private TemplateStorage.Unit getDefaultTemplateStorageUnit() {
        switch (this.creationType) {
            case "html_xslt": {
                return TemplateStorageUnitFactory.newXsltHtml(this.bdfServer, this.templateKey, this.options, this.initAttributes);
            }
            case "fragment_xslt": {
                return TemplateStorageUnitFactory.newXsltFragment(this.bdfServer, this.templateKey, this.initAttributes);
            }
            case "odt_xslt": {
                return TemplateStorageUnitFactory.newXsltOdt(this.bdfServer, this.templateKey, this.options, this.initAttributes);
            }
            case "odt_properties": {
                return TemplateStorageUnitFactory.newPropertiesOdt(this.bdfServer, PathConfigurationBuilder.build(this.bdfServer), this.templateKey, this.tableExportName, this.initAttributes);
            }
        }
        throw new ShouldNotOccurException("test done before");
    }
}

