/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.commands.exportation.AbstractDefChangeCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.balayage.BalayageDef;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.tools.exportation.balayage.BalayageDefBuilder;
import net.fichotheque.tools.exportation.balayage.BalayagePostscriptumBuilder;
import net.fichotheque.tools.exportation.balayage.dom.BalayageUnitsDOMReader;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class BalayageDefChangeCommand
extends AbstractDefChangeCommand {
    public static final String COMMANDNAME = "BalayageDefChange";
    public static final String COMMANDKEY = "_ EXP-53";
    public static final String LANGS_PARAMNAME = "langs";
    public static final String DEFAULTLANGOPTION_PARAMNAME = "defaultlangoption";
    public static final String IGNORETRANSFORMATION = "ignoretransformation";
    public static final String UNITSXML = "unitsxml";
    public static final String SCRIPT = "script";
    public static final String SCRUTARI = "scrutari";
    public static final String SQL = "sql";
    private BalayageDef balayageDef;

    public BalayageDefChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        BalayageDescription balayageDescription = this.bdfServer.getBalayageManager().putBalayageDef(this.balayageDef, editOrigin);
        this.putResultObject("obj.templatedescription", balayageDescription);
        this.setDone("_ done.exportation.balayagedefchange", this.balayageDef.getName());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        BalayageDescription balayageDescription = this.requestHandler.getMandatoryBalayageDescription();
        String defaultLangOption = this.getMandatory(DEFAULTLANGOPTION_PARAMNAME);
        String langs = this.getMandatory(LANGS_PARAMNAME);
        boolean ignoreTransformation = this.requestHandler.isTrue(IGNORETRANSFORMATION);
        BalayageDefBuilder balayageDefBuilder = BalayageDefBuilder.init(balayageDescription.getName(), balayageDescription.getBalayageDef().getAttributes()).setTargetName(this.getTargetName()).setTargetPath(this.getTargetPath()).setIgnoreTransformation(ignoreTransformation);
        try {
            balayageDefBuilder.setDefaultLangOption(defaultLangOption);
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.wrongParameterValue(DEFAULTLANGOPTION_PARAMNAME, defaultLangOption);
        }
        for (Lang lang : LangsUtils.toCleanLangArray(langs)) {
            balayageDefBuilder.addLang(lang);
        }
        BalayagePostscriptumBuilder balayagePostscriptumBuilder = balayageDefBuilder.getBalayagePostscriptumBuilder();
        this.checkScript(balayagePostscriptumBuilder);
        this.checkScrutari(balayagePostscriptumBuilder);
        this.checkSql(balayagePostscriptumBuilder);
        this.checkUnitsXml(balayageDefBuilder);
        this.checkSelectionOptions(balayageDefBuilder.getSelectionOptionsBuilder());
        this.checkDefBuilder(balayageDefBuilder);
        this.balayageDef = balayageDefBuilder.toBalayageDef();
    }

    private void checkScript(BalayagePostscriptumBuilder balayagePostscriptumBuilder) throws ErrorMessageException {
        String[] values;
        for (String value : values = this.requestHandler.getTokens(SCRIPT)) {
            balayagePostscriptumBuilder.addExternalScript(value);
        }
    }

    private void checkScrutari(BalayagePostscriptumBuilder balayagePostscriptumBuilder) throws ErrorMessageException {
        String[] values;
        for (String value : values = this.requestHandler.getTokens(SCRUTARI)) {
            balayagePostscriptumBuilder.addScrutariExport(value);
        }
    }

    private void checkSql(BalayagePostscriptumBuilder balayagePostscriptumBuilder) throws ErrorMessageException {
        String[] values;
        for (String value : values = this.requestHandler.getTokens(SQL)) {
            balayagePostscriptumBuilder.addSqlExport(value);
        }
    }

    private void checkUnitsXml(BalayageDefBuilder balayageDefBuilder) throws ErrorMessageException {
        String unitsXml = this.requestHandler.getTrimedParameter(UNITSXML);
        if (unitsXml.isEmpty()) {
            return;
        }
        unitsXml = "<units>" + unitsXml + "</units>";
        try {
            Document document = DOMUtils.parseDocument(unitsXml);
            BalayageUnitsDOMReader.init(this.fichotheque, balayageDefBuilder, LogUtils.NULL_MULTIMESSAGEHANDLER).read(document.getDocumentElement());
        }
        catch (SAXException saxException) {
            throw BdfErrors.error("_ error.wrong.unitsxml", saxException.getMessage());
        }
    }
}

