/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.AccessManager;
import fr.exemole.bdfserver.commands.exportation.AbstractDefChangeCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.exportation.access.AccessDef;
import net.fichotheque.tools.exportation.access.AccessDefBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class AccessChangeCommand
extends AbstractDefChangeCommand {
    public static final String COMMANDNAME = "AccessChange";
    public static final String COMMANDKEY = "_ EXP-63";
    public static final String TABLEEXPORTNAME_PARAMNAME = "tableexportname";
    public static final String TYPE_PARAMNAME = "type";
    public static final String TOKEN_PARAMNAME = "token";
    private AccessDef accessDef;

    public AccessChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        AccessManager accessManager = this.bdfServer.getAccessManager();
        accessManager.putAccessDef(this.accessDef);
        this.putResultObject("obj.accessdef", this.accessDef);
        this.setDone("_ done.exportation.accesschange", this.accessDef.getName());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        AccessDef currentAccessDef = this.requestHandler.getMandatoryAccessDef();
        String type = this.getType();
        String token = "";
        if (type.equals(TOKEN_PARAMNAME) && (token = this.requestHandler.getTrimedParameter(TOKEN_PARAMNAME)).isEmpty()) {
            throw BdfErrors.emptyMandatoryParameter(TOKEN_PARAMNAME);
        }
        String tableExportName = this.getMandatory(TABLEEXPORTNAME_PARAMNAME);
        AccessDefBuilder accessDefBuilder = AccessDefBuilder.init(currentAccessDef.getName()).setType(type).setToken(token).setTableExportName(tableExportName);
        this.checkSelectionOptions(accessDefBuilder.getSelectionOptionsBuilder());
        this.checkDefBuilder(accessDefBuilder);
        this.accessDef = accessDefBuilder.toAccessDef();
    }

    private String getType() throws ErrorMessageException {
        String type = this.getMandatory(TYPE_PARAMNAME);
        try {
            return AccessDef.checkType(type);
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.unknownParameterValue(TYPE_PARAMNAME, type);
        }
    }
}

