/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.tools.reponderation.ReponderationEngine;
import net.fichotheque.tools.reponderation.ReponderationLog;
import net.fichotheque.tools.reponderation.ReponderationParameters;
import net.fichotheque.utils.CorpusUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.CommandMessageBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class ReponderationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "Reponderation";
    public static final String COMMANDKEY = "_ CRP-24";
    public static final String MODE_PARAMNAME = "mode";
    public static final String SELECTION_MODE_PARAMVALUE = "selection";
    public static final String LIST_MODE_PARAMVALUE = "list";
    public static final String IDTOKENS_PARAMNAME = "idtokens";
    public static final String CROISEMENTSUBSET_PARAMNAME = "croisementsubset";
    public static final String OLDMODE_PARAMNAME = "oldmode";
    public static final String NEWMODE_PARAMNAME = "newmode";
    public static final String OLDPOIDS_PARAMNAME = "oldpoids";
    public static final String NEWPOIDS_PARAMNAME = "newpoids";
    private ReponderationParameters reponderationParameters;

    public ReponderationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        ReponderationLog reponderationLog;
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            reponderationLog = ReponderationEngine.run(this.reponderationParameters, session.getFichothequeEditor());
            if (reponderationLog.getErrorCount() > 0) {
                throw new ShouldNotOccurException("test done before");
            }
        }
        this.putResultObject("obj.duplicationlog", reponderationLog);
        this.setDone("_ done.corpus.reponderation", this.reponderationParameters.getOriginSubsetKey(), this.reponderationParameters.getCroisementSubsetKey(), reponderationLog.getResultCount());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        ReponderationLog reponderationLog;
        int errorCount;
        Subset croisementSubset;
        this.checkFichothequeAdmin();
        Corpus corpus = this.requestHandler.getMandatoryCorpus();
        String mode = this.getMandatory(MODE_PARAMNAME);
        String destinationString = this.requestHandler.getTrimedParameter(CROISEMENTSUBSET_PARAMNAME);
        if (!destinationString.isEmpty()) {
            croisementSubset = this.requestHandler.getMandatorySubset(CROISEMENTSUBSET_PARAMNAME);
            if (croisementSubset instanceof Sphere) {
                throw BdfErrors.unsupportedParameterValue(CROISEMENTSUBSET_PARAMNAME, destinationString);
            }
        } else {
            croisementSubset = corpus;
        }
        String oldMode = this.getMandatory(OLDMODE_PARAMNAME).trim();
        String newMode = this.getMandatory(NEWMODE_PARAMNAME).trim();
        this.reponderationParameters = new ReponderationParameters(corpus.getSubsetKey(), croisementSubset.getSubsetKey());
        try {
            this.reponderationParameters.setOldMode(oldMode);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.mode", oldMode);
        }
        try {
            this.reponderationParameters.setNewMode(newMode);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.mode", newMode);
        }
        String oldpoidsString = this.getMandatory(OLDPOIDS_PARAMNAME).trim();
        int oldPoids = -1;
        if (oldpoidsString.length() > 0) {
            try {
                oldPoids = Integer.parseInt(oldpoidsString);
            }
            catch (NumberFormatException nfe) {
                throw BdfErrors.error("_ error.wrong.poids", oldpoidsString);
            }
        }
        this.reponderationParameters.setOldPoids(oldPoids);
        String newpoidsString = this.getMandatory(NEWPOIDS_PARAMNAME);
        int newPoids = -1;
        if (newpoidsString.length() > 0) {
            try {
                newPoids = Integer.parseInt(newpoidsString);
            }
            catch (NumberFormatException nfe) {
                throw BdfErrors.error("_ error.wrong.poids", newpoidsString);
            }
        }
        this.reponderationParameters.setNewPoids(newPoids);
        if (oldMode.equals(newMode) && oldPoids == newPoids) {
            throw BdfErrors.error("_ error.unsupported.samereponderation");
        }
        if (mode.equals(SELECTION_MODE_PARAMVALUE)) {
            List<FicheMeta> ficheMetaList = CorpusUtils.getFicheMetaListByCorpus(this.bdfUser.getSelectedFiches(), corpus);
            if (ficheMetaList.isEmpty()) {
                throw BdfErrors.error("_ error.empty.originselection");
            }
            for (FicheMeta ficheMeta : ficheMetaList) {
                this.reponderationParameters.addOriginId(ficheMeta.getId());
            }
        } else if (mode.equals(LIST_MODE_PARAMVALUE)) {
            String idTokens = this.getMandatory(IDTOKENS_PARAMNAME);
            StringBuilder tokenErrorBuffer = new StringBuilder();
            String[] tokens = StringUtils.getTechnicalTokens(idTokens, true);
            int tokenLength = tokens.length;
            if (tokenLength == 0) {
                throw BdfErrors.error("_ error.empty.idtokens");
            }
            for (int i = 0; i < tokenLength; ++i) {
                String token = tokens[i];
                boolean done = false;
                try {
                    int id = Integer.parseInt(token);
                    if (id > 0) {
                        done = true;
                        this.reponderationParameters.addOriginId(id);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (done) continue;
                if (tokenErrorBuffer.length() > 0) {
                    tokenErrorBuffer.append("; ");
                }
                tokenErrorBuffer.append(token);
            }
            if (tokenErrorBuffer.length() > 0) {
                throw BdfErrors.error("_ error.wrong.idtokens", tokenErrorBuffer.toString());
            }
        }
        if ((errorCount = (reponderationLog = ReponderationEngine.test(this.reponderationParameters, this.fichotheque)).getErrorCount()) > 0) {
            CommandMessageBuilder commandMessageBuilder = CommandMessageBuilder.init();
            for (int i = 0; i < errorCount; ++i) {
                ReponderationLog.ReponderationError error = reponderationLog.getError(i);
                Object value = this.getErrorValue(error);
                String errorKey = error.getErrorKey();
                if (errorKey.equals("missing_origin_id_error")) {
                    commandMessageBuilder.addMultiError("_ error.unknown.id", value);
                    continue;
                }
                commandMessageBuilder.addMultiError("_ error.exception.internalerror", errorKey);
            }
            throw BdfErrors.error(commandMessageBuilder, "_ error.list.reponderation");
        }
    }

    private Object getErrorValue(ReponderationLog.ReponderationError error) {
        int idCount = error.getIdCount();
        if (idCount == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < idCount; ++i) {
            if (i > 0) {
                buf.append("; ");
            }
            buf.append(error.getId(i));
        }
        return buf.toString();
    }
}

