/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.namespaces.CommandSpace;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import java.util.List;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Subset;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.duplication.DuplicationEngine;
import net.fichotheque.tools.duplication.DuplicationFilter;
import net.fichotheque.tools.duplication.DuplicationFilterParser;
import net.fichotheque.tools.duplication.DuplicationParameters;
import net.fichotheque.tools.duplication.SubsetMatch;
import net.fichotheque.utils.CorpusUtils;
import net.mapeadores.util.logging.CommandMessageBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class DuplicationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "Duplication";
    public static final String COMMANDKEY = "_ CRP-23";
    public static final String MODE_PARAMNAME = "mode";
    public static final String SELECTION_MODE_PARAMVALUE = "selection";
    public static final String LIST_MODE_PARAMVALUE = "list";
    public static final String IDTOKENS_PARAMNAME = "idtokens";
    public static final String LINKTOORIGIN_PARAMNAME = "linktoorigin";
    public static final String MODE_LINKTOORIGIN_PARAMNAME = "linktoorigin_mode";
    public static final String POIDS_LINKTOORIGIN_PARAMNAME = "linktoorigin_poids";
    public static final String DESTINATION_PARAMNAME = "destination";
    public static final String WITHDESTINATIONIDS_PARAMNAME = "withdestinationids";
    public static final String FILTER_PARAMNAME = "filter";
    public static final String FILTER_ALL_PARAMVALUE = "all";
    public static final String FILTER_FICHEONLY_PARAMVALUE = "ficheonly";
    public static final String FILTER_EXCLUDE_PARAMVALUE = "exclude";
    public static final String EXCLUDE_PARAMNAME = "exclude";
    public static final String STORE_PARAMNAME = "store";
    public static final String FIELDMATCHING_PARAMNAME = "fieldmatching";
    private DuplicationParameters duplicationParameters;
    private boolean excludeStore;
    private String[] excludeTokens;

    public DuplicationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        SubsetMatch subsetMatch;
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            subsetMatch = DuplicationEngine.run(this.duplicationParameters, session.getFichothequeEditor());
            if (this.excludeStore) {
                session.getFichothequeEditor().putAttribute(this.duplicationParameters.getOriginCorpus().getCorpusMetadata(), CommandSpace.DUPLICATION_EXCLUDE_KEY, this.excludeTokens);
            }
        }
        this.putResultObject("obj.subsetmatch", subsetMatch);
        this.setDone("_ done.corpus.duplication", this.duplicationParameters.getOriginCorpus().getSubsetKey(), this.duplicationParameters.getDestinationCorpus().getSubsetKey(), subsetMatch.size());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        Corpus corpus = this.requestHandler.getMandatoryCorpus();
        String mode = this.getMandatory(MODE_PARAMNAME);
        Corpus destinationCorpus = (Corpus)this.requestHandler.getMandatorySubset((short)1, DESTINATION_PARAMNAME);
        boolean withDestinationIds = false;
        if (mode.equals(LIST_MODE_PARAMVALUE)) {
            withDestinationIds = this.requestHandler.isTrue(WITHDESTINATIONIDS_PARAMNAME);
        }
        if (destinationCorpus.getMasterSubset() != null && !withDestinationIds) {
            throw BdfErrors.error("_ error.unsupported.destinationidsrequired");
        }
        this.duplicationParameters = new DuplicationParameters(corpus, destinationCorpus);
        if (mode.equals(SELECTION_MODE_PARAMVALUE)) {
            List<FicheMeta> ficheMetaList = CorpusUtils.getFicheMetaListByCorpus(this.bdfUser.getSelectedFiches(), corpus);
            if (ficheMetaList.isEmpty()) {
                throw BdfErrors.error("_ error.empty.originselection");
            }
            for (FicheMeta ficheMeta : ficheMetaList) {
                this.duplicationParameters.addFicheMeta(ficheMeta);
            }
        } else if (mode.equals(LIST_MODE_PARAMVALUE)) {
            this.parseListMode(withDestinationIds);
        }
        this.parseFilter();
        this.parseFieldMatching();
        this.parseLinkToOrigin();
    }

    private void parseListMode(boolean withDestinationIds) throws ErrorMessageException {
        String idTokens = this.getMandatory(IDTOKENS_PARAMNAME);
        CommandMessageBuilder commandMessageBuilder = CommandMessageBuilder.init();
        if (withDestinationIds) {
            String[] lines = StringUtils.getLineTokens(idTokens, (short)2);
            if (lines.length == 0) {
                throw BdfErrors.error("_ error.empty.idtokens");
            }
            this.parseMatchLines(this.duplicationParameters, lines, commandMessageBuilder);
        } else {
            String[] tokens = StringUtils.getTechnicalTokens(idTokens, true);
            if (tokens.length == 0) {
                throw BdfErrors.error("_ error.empty.idtokens");
            }
            this.parseSimpleIdTokens(this.duplicationParameters, tokens, commandMessageBuilder);
        }
        if (commandMessageBuilder.hasMultiError()) {
            throw BdfErrors.error(commandMessageBuilder, "_ error.list.idtokens");
        }
    }

    private void parseSimpleIdTokens(DuplicationParameters duplicationParameters, String[] tokens, CommandMessageBuilder commandMessageBuilder) {
        for (String token : tokens) {
            try {
                int id = Integer.parseInt(token);
                if (id > 0) {
                    FicheMeta origin = duplicationParameters.getOriginCorpus().getFicheMetaById(id);
                    if (origin != null) {
                        duplicationParameters.addFicheMeta(origin);
                        continue;
                    }
                    commandMessageBuilder.addMultiError("_ error.unknown.id", token);
                    continue;
                }
                commandMessageBuilder.addMultiError("_ error.wrong.id", token);
            }
            catch (NumberFormatException nfe) {
                commandMessageBuilder.addMultiError("_ error.wrong.id", token);
            }
        }
    }

    private void parseMatchLines(DuplicationParameters duplicationParameters, String[] lines, CommandMessageBuilder commandMessageBuilder) {
        Subset masterSubset = duplicationParameters.getDestinationCorpus().getMasterSubset();
        for (String line : lines) {
            String[] tokens = StringUtils.getTechnicalTokens(line, true);
            if (tokens.length < 2) {
                commandMessageBuilder.addMultiError("_ error.wrong.id", line);
                continue;
            }
            FicheMeta origin = null;
            String firstToken = tokens[0];
            try {
                int id = Integer.parseInt(firstToken);
                if (id > 0) {
                    origin = duplicationParameters.getOriginCorpus().getFicheMetaById(id);
                    if (origin == null) {
                        commandMessageBuilder.addMultiError("_ error.unknown.id", firstToken);
                    }
                } else {
                    commandMessageBuilder.addMultiError("_ error.wrong.id", firstToken);
                }
            }
            catch (NumberFormatException nfe) {
                commandMessageBuilder.addMultiError("_ error.wrong.id", firstToken);
            }
            if (origin == null) continue;
            String secondToken = tokens[1];
            try {
                int destinationId = Integer.parseInt(secondToken);
                if (destinationId < 1) {
                    if (masterSubset != null) {
                        commandMessageBuilder.addMultiError("_ error.empty.mandatorydestinationid", secondToken);
                        continue;
                    }
                    duplicationParameters.addFicheMeta(origin);
                    continue;
                }
                try {
                    duplicationParameters.addFicheMeta(origin, destinationId);
                }
                catch (ExistingIdException eie) {
                    commandMessageBuilder.addMultiError("_ error.existing.id", secondToken);
                }
                catch (NoMasterIdException nmie) {
                    commandMessageBuilder.addMultiError("error.unknown.mastersubsetitem", secondToken, masterSubset.getSubsetKeyString());
                }
            }
            catch (NumberFormatException nfe) {
                commandMessageBuilder.addMultiError("_ error.wrong.destinationid", secondToken);
            }
        }
    }

    private void parseFieldMatching() throws ErrorMessageException {
        String[] lines;
        String matching = this.requestHandler.getTrimedParameter(FIELDMATCHING_PARAMNAME);
        if (matching.isEmpty()) {
            return;
        }
        CommandMessageBuilder commandMessageBuilder = CommandMessageBuilder.init();
        for (String line : lines = StringUtils.getLineTokens(matching, (short)2)) {
            int idx = line.indexOf(61);
            if (idx == -1) {
                commandMessageBuilder.addMultiError("_ error.empty.separator", "=", line);
            }
            String originPart = line.substring(0, idx).trim();
            String destinationPart = line.substring(idx + 1).trim();
            FieldKey originKey = null;
            FieldKey destinationKey = null;
            try {
                originKey = FieldKey.parse(originPart);
            }
            catch (ParseException pe) {
                commandMessageBuilder.addMultiError("_ error.wrong.fieldkey", originPart);
            }
            try {
                destinationKey = FieldKey.parse(destinationPart);
            }
            catch (ParseException pe) {
                commandMessageBuilder.addMultiError("_ error.wrong.fieldkey", destinationPart);
            }
            if (originKey == null || destinationKey == null) continue;
            if (originKey.getCategory() != destinationKey.getCategory()) {
                commandMessageBuilder.addMultiError("_ error.unsupported.differentcategory", line);
                continue;
            }
            this.duplicationParameters.addFieldMatching(originKey, destinationKey);
        }
        if (commandMessageBuilder.hasMultiError()) {
            throw BdfErrors.error(commandMessageBuilder, "_ error.list.fieldmatching");
        }
    }

    private void parseLinkToOrigin() throws ErrorMessageException {
        boolean linkToOrigin = this.requestHandler.isTrue(LINKTOORIGIN_PARAMNAME);
        if (linkToOrigin) {
            String linkToOriginMode = this.getMandatory(MODE_LINKTOORIGIN_PARAMNAME).trim();
            String linkToOriginPoids = this.getMandatory(POIDS_LINKTOORIGIN_PARAMNAME).trim();
            int poids = 1;
            if (linkToOriginPoids.length() > 0) {
                boolean done = false;
                try {
                    poids = Integer.parseInt(linkToOriginPoids);
                    if (poids > 0) {
                        done = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (!done) {
                    throw BdfErrors.error("_ error.wrong.poids", linkToOriginPoids);
                }
            }
            try {
                this.duplicationParameters.setLinkWithOrigin(linkToOriginMode, poids);
            }
            catch (ParseException pe) {
                throw BdfErrors.error("_ error.wrong.mode", linkToOriginPoids);
            }
        }
    }

    private void parseFilter() throws ErrorMessageException {
        String filter;
        switch (filter = this.getMandatory(FILTER_PARAMNAME)) {
            case "ficheonly": {
                this.duplicationParameters.setFicheFilter((short)2, null);
                break;
            }
            case "exclude": {
                this.duplicationParameters.setFicheFilter((short)3, this.parseExcludeFilter());
                break;
            }
            default: {
                this.duplicationParameters.setFicheFilter((short)1, null);
            }
        }
    }

    private DuplicationFilter parseExcludeFilter() throws ErrorMessageException {
        this.excludeStore = this.requestHandler.isTrue(STORE_PARAMNAME);
        this.excludeTokens = StringUtils.getTechnicalTokens(this.getMandatory("exclude"), true);
        return DuplicationFilterParser.parseExclude(this.excludeTokens);
    }
}

