/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.configuration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ExtensionActivationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ExtensionActivation";
    public static final String COMMANDKEY = "_ CNF-18";
    public static final String ACTIVATION_PARAMNAME = "activation";
    private List<String> activeExtensionList;

    public ExtensionActivationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("configuration", COMMANDNAME);){
            session.getBdfServerEditor().setActiveExtensionList(this.activeExtensionList);
        }
        this.setDone("_ done.configuration.extensionactivation", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        String[] values = this.requestHandler.getTokens(ACTIVATION_PARAMNAME);
        this.activeExtensionList = new ArrayList<String>();
        for (String value : values) {
            if ((value = value.trim()).length() <= 0) continue;
            this.activeExtensionList.add(value);
        }
    }
}

