/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.album.Illustration;
import net.fichotheque.croisement.CroisementChanges;
import net.fichotheque.tools.croisement.CroisementChangeEngine;
import net.fichotheque.tools.croisement.LienBuffer;
import net.fichotheque.tools.parsers.croisement.LienBufferParser;
import net.fichotheque.tools.permission.PermissionPredicate;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class CroisementAddCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "CroisementAdd";
    public static final String COMMANDKEY = "_ ALB-14";
    public static final String ADD_PARAMNAME = "add";
    private Illustration illustration;
    private CroisementChanges croisementChanges;

    public CroisementAddCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("album", COMMANDNAME);){
            session.getFichothequeEditor().getCroisementEditor().updateCroisements(this.illustration, this.croisementChanges);
        }
        this.putResultObject("obj.album", this.illustration.getAlbum());
        this.putResultObject("obj.illustration", this.illustration);
        this.setDone("_ done.album.croisementadd", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.illustration = this.requestHandler.getMandatoryIllustration();
        this.getPermissionChecker().checkWrite(this.illustration);
        PermissionPredicate predicate = PermissionPredicate.read(this.getPermissionSummary());
        String addString = this.getMandatory(ADD_PARAMNAME);
        String[] tokens = StringUtils.getTechnicalTokens(addString, false);
        CroisementChangeEngine croisementChangeEngine = CroisementChangeEngine.appendEngine(this.illustration);
        boolean done = false;
        for (String token : tokens) {
            try {
                LienBuffer lienBuffer = LienBufferParser.parse(this.fichotheque, token, (short)1);
                if (!predicate.test(lienBuffer.getSubsetItem())) continue;
                croisementChangeEngine.addLien(lienBuffer);
                done = true;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (!done) {
            throw BdfErrors.error("_ error.wrong.fichekeys");
        }
        this.croisementChanges = croisementChangeEngine.toCroisementChanges();
    }
}

