/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfCommand;
import fr.exemole.bdfserver.commands.album.AlbumAttributeChangeCommand;
import fr.exemole.bdfserver.commands.album.AlbumCreationCommand;
import fr.exemole.bdfserver.commands.album.AlbumDimChangeCommand;
import fr.exemole.bdfserver.commands.album.AlbumDimCreationCommand;
import fr.exemole.bdfserver.commands.album.AlbumDimRemoveCommand;
import fr.exemole.bdfserver.commands.album.AlbumPhrasesCommand;
import fr.exemole.bdfserver.commands.album.AlbumRemoveCommand;
import fr.exemole.bdfserver.commands.album.CroisementAddCommand;
import fr.exemole.bdfserver.commands.album.CroisementRemoveCommand;
import fr.exemole.bdfserver.commands.album.IllustrationAttributeChangeCommand;
import fr.exemole.bdfserver.commands.album.IllustrationFileDownloadCommand;
import fr.exemole.bdfserver.commands.album.IllustrationFileUploadCommand;
import fr.exemole.bdfserver.commands.album.IllustrationRemoveCommand;
import fr.exemole.bdfserver.commands.album.ToolCropCommand;
import fr.exemole.bdfserver.commands.album.ToolResizeCommand;
import net.mapeadores.util.request.RequestMap;

public class AlbumCommandFactory {
    private AlbumCommandFactory() {
    }

    public static BdfCommand getBdfCommand(BdfServer bdfServer, RequestMap requestMap, String commandName) {
        switch (commandName) {
            case "AlbumCreation": {
                return new AlbumCreationCommand(bdfServer, requestMap);
            }
            case "AlbumDimCreation": {
                return new AlbumDimCreationCommand(bdfServer, requestMap);
            }
            case "AlbumDimChange": {
                return new AlbumDimChangeCommand(bdfServer, requestMap);
            }
            case "AlbumDimRemove": {
                return new AlbumDimRemoveCommand(bdfServer, requestMap);
            }
            case "IllustrationFileUpload": {
                return new IllustrationFileUploadCommand(bdfServer, requestMap);
            }
            case "IllustrationFileDownload": {
                return new IllustrationFileDownloadCommand(bdfServer, requestMap);
            }
            case "ToolCrop": {
                return new ToolCropCommand(bdfServer, requestMap);
            }
            case "ToolResize": {
                return new ToolResizeCommand(bdfServer, requestMap);
            }
            case "AlbumAttributeChange": {
                return new AlbumAttributeChangeCommand(bdfServer, requestMap);
            }
            case "AlbumIntitule": {
                return new AlbumPhrasesCommand(bdfServer, requestMap);
            }
            case "AlbumRemove": {
                return new AlbumRemoveCommand(bdfServer, requestMap);
            }
            case "IllustrationAttributeChange": {
                return new IllustrationAttributeChangeCommand(bdfServer, requestMap);
            }
            case "IllustrationRemove": {
                return new IllustrationRemoveCommand(bdfServer, requestMap);
            }
            case "CroisementRemove": {
                return new CroisementRemoveCommand(bdfServer, requestMap);
            }
            case "CroisementAdd": {
                return new CroisementAddCommand(bdfServer, requestMap);
            }
        }
        return null;
    }
}

