/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.administration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.roles.RoleUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class RoleRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "RoleRemove";
    public static final String COMMANDKEY = "_ ROL-03";
    private Role role;

    public RoleRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        String roleName = this.role.getName();
        try (EditSession session = this.startEditSession("administration", COMMANDNAME);){
            session.getBdfServerEditor().getRoleEditor().removeRole(this.role);
        }
        this.setDone("_ done.administration.roleremove", roleName);
        this.putResultObject("obj.string", roleName);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.role = this.requestHandler.getMandatoryRole();
        if (RoleUtils.isDefaultRole(this.role)) {
            throw BdfErrors.wrongParameterValue("role", "default role");
        }
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
    }
}

