/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.addenda;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.addenda.Document;
import net.fichotheque.croisement.CroisementChanges;
import net.fichotheque.tools.croisement.CroisementChangeEngine;
import net.fichotheque.tools.croisement.LienBuffer;
import net.fichotheque.tools.parsers.croisement.LienBufferParser;
import net.fichotheque.tools.permission.PermissionPredicate;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class CroisementAddCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "CroisementAdd";
    public static final String COMMANDKEY = "_ ADD-09";
    public static final String ADD_PARAMNAME = "add";
    private Document document;
    private CroisementChanges croisementChanges;

    public CroisementAddCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("addenda", COMMANDNAME);){
            session.getFichothequeEditor().getCroisementEditor().updateCroisements(this.document, this.croisementChanges);
        }
        this.putResultObject("obj.addenda", this.document.getAddenda());
        this.putResultObject("obj.document", this.document);
        this.setDone("_ done.addenda.croisementadd", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.document = this.requestHandler.getMandatoryDocument();
        this.getPermissionChecker().checkWrite(this.document);
        PermissionPredicate predicate = PermissionPredicate.read(this.getPermissionSummary());
        String addString = this.getMandatory(ADD_PARAMNAME);
        String[] tokens = StringUtils.getTechnicalTokens(addString, false);
        CroisementChangeEngine croisementChangeEngine = CroisementChangeEngine.appendEngine(this.document);
        boolean done = false;
        for (String token : tokens) {
            try {
                LienBuffer lienBuffer = LienBufferParser.parse(this.fichotheque, token, (short)1);
                if (!predicate.test(lienBuffer.getSubsetItem())) continue;
                croisementChangeEngine.addLien(lienBuffer);
                done = true;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (!done) {
            throw BdfErrors.error("_ error.wrong.fichekeys");
        }
        this.croisementChanges = croisementChangeEngine.toCroisementChanges();
    }
}

