/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.api.users;

import fr.exemole.bdfserver.api.BdfServerConstants;
import fr.exemole.bdfserver.api.exportation.table.FicheTableParameters;
import fr.exemole.bdfserver.api.exportation.table.TableExportParameters;
import fr.exemole.bdfserver.api.namespaces.BdfUserSpace;
import fr.exemole.bdfserver.tools.exportation.table.FicheTableParametersBuilder;
import fr.exemole.bdfserver.tools.exportation.table.TableExportParametersBuilder;
import java.util.Locale;
import net.fichotheque.exportation.table.TableExportConstants;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.selection.FicheQuery;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;

public interface BdfUserPrefs {
    @Nullable
    public Lang getWorkingLang();

    @Nullable
    public Locale getCustomFormatLocale();

    @Nullable
    public LangPreference getCustomLangPreference();

    public Attributes getAttributes();

    @Nullable
    public FicheQuery getDefaultFicheQuery();

    default public String getSimpleTemplateName(TransformationKey transformationKey) {
        AttributeKey attributeKey = BdfUserSpace.toSimpleTemplateAttributeKey(transformationKey);
        return this.getAttributes().getFirstValue(attributeKey);
    }

    default public String getStreamTemplateName(TransformationKey transformationKey, String extension) {
        AttributeKey attributeKey = BdfUserSpace.toStreamTemplateAttributeKey(transformationKey, extension);
        return this.getAttributes().getFirstValue(attributeKey);
    }

    default public boolean getBoolean(AttributeKey attributeKey) {
        return this.getAttributes().isTrue(attributeKey);
    }

    default public String getDefaultHeaderType() {
        Attribute attribute = this.getAttributes().getAttribute(BdfUserSpace.TABLEEXPORT_HEADERTYPE_KEY);
        if (attribute != null) {
            try {
                return TableExportConstants.checkHeaderType(attribute.getFirstValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return "columntitle";
    }

    default public FicheTableParameters getDefaultFicheTableParameters() {
        Attribute withAttribute;
        FicheTableParametersBuilder builder = new FicheTableParametersBuilder();
        String patternMode = this.getAttributes().getFirstValue(BdfUserSpace.TABLEEXPORT_PATTERNMODE_KEY);
        if (patternMode != null) {
            try {
                builder.setPatternMode(patternMode);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((withAttribute = this.getAttributes().getAttribute(BdfUserSpace.TABLEEXPORT_WITH_KEY)) != null) {
            int valueLength = withAttribute.size();
            for (int i = 0; i < valueLength; ++i) {
                builder.putWith((String)withAttribute.get(i));
            }
        }
        return builder.toFicheTableParameters();
    }

    default public TableExportParameters getDefaultTableExportParameters() {
        return TableExportParametersBuilder.init().setHeaderType(this.getDefaultHeaderType()).setFicheTableParameters(this.getDefaultFicheTableParameters()).toTableExportParameters();
    }

    default public String getDateInputsType() {
        String value = this.getAttributes().getFirstValue(BdfUserSpace.DATEINPUTS_KEY);
        if (value == null) {
            return "iso";
        }
        try {
            return BdfServerConstants.checkDateInputsType(value);
        }
        catch (IllegalArgumentException iae) {
            return "iso";
        }
    }
}

