/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.simplegrille.smgrimpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.desmodo.simplegrille.api.SimpleAtlas;
import net.desmodo.simplegrille.api.SimpleContexte;
import net.desmodo.simplegrille.api.SimpleDescripteurFils;
import net.desmodo.simplegrille.api.SimpleDescripteurFilsList;
import net.desmodo.simplegrille.api.SimpleDescripteurPere;
import net.desmodo.simplegrille.api.SimpleStructure;
import net.desmodo.simplegrille.smgrimpl.LangAccoladeArgument;
import net.desmodo.simplegrille.smgrimpl.SimpleDescripteurFilsImpl;
import net.desmodo.simplegrille.smstimpl.AbstractSimpleLabelHolder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.AccoladeArgument;
import net.mapeadores.util.text.AccoladePattern;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.ValueResolver;

public class SimpleAtlasImpl
extends AbstractSimpleLabelHolder
implements SimpleAtlas {
    private final SimpleStructure simpleStructure;
    private final AllSimpleDescripteurFilsList allSimpleDescripteurFilsList = new AllSimpleDescripteurFilsList();
    private final String prefixe;
    private final AccoladePattern uiPattern;
    private final String uiPatternString;
    private int autoIncrement = 1;

    SimpleAtlasImpl(SimpleStructure simpleStructure, String prefixe, int autoIncrement, List<SimpleDescripteurFilsImpl> list, AccoladePattern uiPattern, String uiPatternString, Map<Lang, Label> libelleMap) {
        super(libelleMap);
        this.simpleStructure = simpleStructure;
        this.prefixe = prefixe;
        this.autoIncrement = autoIncrement;
        for (SimpleDescripteurFilsImpl sdf : list) {
            this.allSimpleDescripteurFilsList.add(sdf);
        }
        this.uiPattern = uiPattern;
        this.uiPatternString = uiPatternString;
    }

    @Override
    public SimpleStructure getSimpleStructure() {
        return this.simpleStructure;
    }

    @Override
    public SimpleDescripteurFils createSimpleDescripteurFils(SimpleDescripteurPere simpleDescripteurPere, SimpleContexte simpleContexte) {
        String newId = String.valueOf(this.autoIncrement);
        ++this.autoIncrement;
        SimpleDescripteurFilsImpl sdf = new SimpleDescripteurFilsImpl(newId, simpleDescripteurPere, simpleContexte, null);
        this.allSimpleDescripteurFilsList.add(sdf);
        return sdf;
    }

    @Override
    public void putLibelle(SimpleDescripteurFils simpleDescripteurFils, Label libelle) {
        SimpleDescripteurFilsImpl impl = (SimpleDescripteurFilsImpl)simpleDescripteurFils;
        impl.putLabel(libelle);
    }

    @Override
    public void removeLibelle(SimpleDescripteurFils simpleDescripteurFils, Lang lang) {
        SimpleDescripteurFilsImpl impl = (SimpleDescripteurFilsImpl)simpleDescripteurFils;
        impl.removeLabel(lang);
    }

    @Override
    public String getPrefixe() {
        return this.prefixe;
    }

    @Override
    public SimpleDescripteurFils getSimpleDescripteurFils(String iddesc) {
        return this.allSimpleDescripteurFilsList.getSimpleDescripteurFils(iddesc);
    }

    @Override
    public SimpleDescripteurFilsList getSimpleDescripteurFilsList() {
        return this.allSimpleDescripteurFilsList;
    }

    @Override
    public SimpleDescripteurFilsList getSimpleDescripteurFilsList(SimpleDescripteurPere simpleDescripteurPere, SimpleContexte simpleContexte) {
        return this.allSimpleDescripteurFilsList.getSimpleDescripteurFilsList(simpleDescripteurPere, simpleContexte);
    }

    @Override
    public int getAutoIncrement() {
        return this.autoIncrement;
    }

    @Override
    public String getUiLib(Labels labels) {
        LangPatternValueSet lpas = new LangPatternValueSet(labels);
        return this.uiPattern.format((ValueResolver)lpas);
    }

    @Override
    public String getUiPatternString() {
        return this.uiPatternString;
    }

    private static class AllSimpleDescripteurFilsList
    implements SimpleDescripteurFilsList {
        private final List<SimpleDescripteurFils> descripteurFilsList = new ArrayList<SimpleDescripteurFils>();
        private final Map<String, SimpleDescripteurFils> descripteurFilsMap = new HashMap<String, SimpleDescripteurFils>();

        private AllSimpleDescripteurFilsList() {
        }

        private SimpleDescripteurFils getSimpleDescripteurFils(String iddesc) {
            return this.descripteurFilsMap.get(iddesc);
        }

        private void add(SimpleDescripteurFils sdf) {
            this.descripteurFilsMap.put(sdf.getIddesc(), sdf);
            this.descripteurFilsList.add(sdf);
        }

        @Override
        public int getSimpleDescripteurFilsCount() {
            return this.descripteurFilsList.size();
        }

        @Override
        public SimpleDescripteurFils getSimpleDescripteurFils(int i) {
            return this.descripteurFilsList.get(i);
        }

        private SimpleDescripteurFilsList getSimpleDescripteurFilsList(SimpleDescripteurPere simpleDescripteurPere, SimpleContexte simpleContexte) {
            SelectionSimpleDescripteurFilsList selection = new SelectionSimpleDescripteurFilsList();
            for (SimpleDescripteurFils sdf : this.descripteurFilsList) {
                if (!sdf.getSimpleDescripteurPere().equals(simpleDescripteurPere) || !sdf.getSimpleContexte().equals(simpleContexte)) continue;
                selection.add(sdf);
            }
            return selection;
        }
    }

    private static class LangPatternValueSet
    implements ValueResolver {
        private final Labels labels;

        private LangPatternValueSet(Labels labels) {
            this.labels = labels;
        }

        public String getValue(AccoladeArgument patternArgument) {
            LangAccoladeArgument lpa = (LangAccoladeArgument)patternArgument;
            return this.labels.seekLabelString(lpa.getLang(), "?");
        }
    }

    private static class SelectionSimpleDescripteurFilsList
    implements SimpleDescripteurFilsList {
        private final List<SimpleDescripteurFils> descripteurFilsList = new ArrayList<SimpleDescripteurFils>();

        private SelectionSimpleDescripteurFilsList() {
        }

        private void add(SimpleDescripteurFils sdf) {
            this.descripteurFilsList.add(sdf);
        }

        @Override
        public int getSimpleDescripteurFilsCount() {
            return this.descripteurFilsList.size();
        }

        @Override
        public SimpleDescripteurFils getSimpleDescripteurFils(int i) {
            return this.descripteurFilsList.get(i);
        }
    }
}

