/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique;

import fr.exemole.bdfext.scarabe.api.analytique.PrerequestDef;
import fr.exemole.bdfext.scarabe.api.analytique.PrerequestDefManager;
import fr.exemole.bdfext.scarabe.tools.analytique.PrerequestDefBuilder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.attr.AttributeBuffer;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.misc.DefBuilder;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class PrerequestDefManagerDOMReader {
    private final MessageHandler messageHandler;

    public PrerequestDefManagerDOMReader(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void updateManager(PrerequestDefManager prerequestDefManager, Element element) {
        RootConsumer rootConsumer = new RootConsumer();
        DOMUtils.readChildren((Element)element, (Consumer)rootConsumer);
        prerequestDefManager.update(rootConsumer.list);
    }

    public List<PrerequestDef> readPrerequestDefList(Element element) {
        RootConsumer rootConsumer = new RootConsumer();
        DOMUtils.readChildren((Element)element, (Consumer)rootConsumer);
        return rootConsumer.list;
    }

    private class RootConsumer
    implements Consumer<Element> {
        private final List<PrerequestDef> list = new ArrayList<PrerequestDef>();

        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("prereq")) {
                int num = this.list.size() + 1;
                PrerequestDefBuilder prerequestDefBuilder = new PrerequestDefBuilder("prereq_" + num);
                DOMUtils.readChildren((Element)element, (Consumer)new PrerequestDefConsumer(prerequestDefBuilder));
                this.list.add(prerequestDefBuilder.toPrerequestDef());
            }
        }
    }

    private class IdConsumer
    implements Consumer<Element> {
        private final PrerequestDefBuilder prerequestDefBuilder;
        private boolean isInclude;

        private IdConsumer(PrerequestDefBuilder prerequestDefBuilder) {
            this.prerequestDefBuilder = prerequestDefBuilder;
        }

        private void setInclude(boolean isInclude) {
            this.isInclude = isInclude;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            String text = XMLUtils.getData((Element)element);
            Object obj = null;
            if (tagName.equals("id") || tagName.equals("idsubset")) {
                try {
                    obj = Integer.parseInt(text);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (tagName.equals("idalpha") && text.length() > 0) {
                obj = text;
            }
            if (obj != null) {
                if (this.isInclude) {
                    this.prerequestDefBuilder.addInclude(obj);
                } else {
                    this.prerequestDefBuilder.addExclude(obj);
                }
            }
        }
    }

    private class PrerequestDefConsumer
    implements Consumer<Element> {
        private final PrerequestDefBuilder prerequestDefBuilder;

        private PrerequestDefConsumer(PrerequestDefBuilder prerequestDefBuilder) {
            this.prerequestDefBuilder = prerequestDefBuilder;
        }

        @Override
        public void accept(Element element) {
            IdConsumer idConsumer = new IdConsumer(this.prerequestDefBuilder);
            String tagName = element.getTagName();
            if (tagName.equals("subset")) {
                String subsetString = XMLUtils.getData((Element)element);
                try {
                    SubsetKey subsetKey = SubsetKey.parse((String)subsetString);
                    this.prerequestDefBuilder.addSubsetKey(subsetKey);
                }
                catch (ParseException parseException) {}
            } else if (tagName.equals("label") || tagName.equals("lib")) {
                try {
                    LabelUtils.readLabel((Element)element, (DefBuilder)this.prerequestDefBuilder);
                }
                catch (ParseException ile) {
                    DomMessages.wrongLangAttribute((MessageHandler)PrerequestDefManagerDOMReader.this.messageHandler, (String)tagName, (String)element.getAttribute("xml:lang"));
                }
            } else if (tagName.equals("include")) {
                idConsumer.setInclude(true);
                DOMUtils.readChildren((Element)element, (Consumer)idConsumer);
            } else if (tagName.equals("exclude")) {
                idConsumer.setInclude(false);
                DOMUtils.readChildren((Element)element, (Consumer)idConsumer);
            } else if (tagName.equals("attr")) {
                AttributeUtils.readAttrElement((AttributeBuffer)this.prerequestDefBuilder.getAttributesBuilder(), (Element)element);
            } else {
                DomMessages.unknownTagWarning((MessageHandler)PrerequestDefManagerDOMReader.this.messageHandler, (String)tagName);
            }
        }
    }
}

