/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.atlas;

import fr.exemole.bdfext.desmoservice.atlas.BdfAtlas;
import fr.exemole.bdfext.desmoservice.atlas.BdfContexte;
import java.util.List;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.Structure;
import net.desmodo.atlas.structure.StructureUtils;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.text.Labels;

class BdfGrille
implements Grille {
    private final BdfAtlas bdfAtlas;
    private final int code;
    private final Motcle motcle;
    private final short type;
    private ContexteList firstLevel = null;

    BdfGrille(BdfAtlas bdfAtlas, Motcle motcle, short type, int code) {
        this.bdfAtlas = bdfAtlas;
        this.type = type;
        this.code = code;
        this.motcle = motcle;
    }

    @Override
    public String getGrilleName() {
        if (this.type == 7) {
            return "";
        }
        String idalpha = this.motcle.getIdalpha();
        int length = this.bdfAtlas.atlasPrefix.length();
        if (idalpha.length() <= length) {
            throw new IllegalStateException("Idalpha (" + idalpha + ") doit commencer par " + this.bdfAtlas.atlasPrefix);
        }
        return idalpha.substring(length);
    }

    @Override
    public synchronized ContexteList getFirstLevelContexteList() {
        if (this.firstLevel == null) {
            List motcleList = this.motcle.getChildList();
            int count = motcleList.size();
            if (count == 0) {
                this.firstLevel = StructureUtils.EMPTY_CONTEXTE_LIST;
            } else {
                Contexte[] array = new BdfContexte[count];
                for (int i = 0; i < count; ++i) {
                    BdfContexte child = this.bdfAtlas.getBdfContexte((Motcle)motcleList.get(i));
                    child.setParent(null);
                    child.setGrille(this);
                    array[i] = child;
                }
                this.firstLevel = StructureUtils.toContexteList(array);
            }
        }
        return this.firstLevel;
    }

    @Override
    public Contexte getContexteByIdctxt(String idctxt) {
        if (idctxt.isEmpty()) {
            if (this.type == 7) {
                return this.bdfAtlas.getStructure().getSpecialContexte((short)6);
            }
            return null;
        }
        return this.bdfAtlas.getContexteByIdctxt(this.type, idctxt, this.motcle.getIdalpha());
    }

    @Override
    public Structure getStructure() {
        return this.bdfAtlas.getStructure();
    }

    @Override
    public Atlas getAtlas() {
        return this.bdfAtlas;
    }

    @Override
    public short getTermType() {
        return this.type;
    }

    @Override
    public Attributes getAttributes() {
        return this.motcle.getAttributes();
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public Labels getLabels() {
        return this.motcle.getLabels();
    }
}

